<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProcessFlightDisruptionAlert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessFlightDisruptionAlert $parameters
     * @return \StructType\ProcessFlightDisruptionAlertResponse|bool
     */
    public function ProcessFlightDisruptionAlert(\StructType\ProcessFlightDisruptionAlert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessFlightDisruptionAlert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProcessFlightDisruptionAlertResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
