<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OAF ServiceType
 * @subpackage Services
 */
class OAF extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OAFlightSegments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OAFlightSegments $parameters
     * @return \StructType\OAFlightSegmentsResponse|bool
     */
    public function OAFlightSegments(\StructType\OAFlightSegments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OAFlightSegments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OAFlightSegmentsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
