<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Manual ServiceType
 * @subpackage Services
 */
class Manual extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ManualRefundCharges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ManualRefundCharges $parameters
     * @return \StructType\ManualRefundChargesResponse|bool
     */
    public function ManualRefundCharges(\StructType\ManualRefundCharges $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ManualRefundCharges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ManualRefundChargesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
