<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for History ServiceType
 * @subpackage Services
 */
class History extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HistoryPNR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HistoryPNR $parameters
     * @return \StructType\HistoryPNRResponse|bool
     */
    public function HistoryPNR(\StructType\HistoryPNR $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HistoryPNR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HistoryPNRResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
