<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSegment ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSegment
 * @subpackage Arrays
 */
class ArrayOfSegment extends AbstractStructArrayBase
{
    /**
     * The Segment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Segment[]
     */
    public $Segment;
    /**
     * Constructor method for ArrayOfSegment
     * @uses ArrayOfSegment::setSegment()
     * @param \StructType\Segment[] $segment
     */
    public function __construct(array $segment = array())
    {
        $this
            ->setSegment($segment);
    }
    /**
     * Get Segment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Segment[]|null
     */
    public function getSegment()
    {
        return isset($this->Segment) ? $this->Segment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSegmentForArrayConstraintsFromSetSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSegmentSegmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfSegmentSegmentItem instanceof \StructType\Segment) {
                $invalidValues[] = is_object($arrayOfSegmentSegmentItem) ? get_class($arrayOfSegmentSegmentItem) : sprintf('%s(%s)', gettype($arrayOfSegmentSegmentItem), var_export($arrayOfSegmentSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Segment property can only contain items of type \StructType\Segment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Segment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Segment[] $segment
     * @return \ArrayType\ArrayOfSegment
     */
    public function setSegment(array $segment = array())
    {
        // validation for constraint: array
        if ('' !== ($segmentArrayErrorMessage = self::validateSegmentForArrayConstraintsFromSetSegment($segment))) {
            throw new \InvalidArgumentException($segmentArrayErrorMessage, __LINE__);
        }
        if (is_null($segment) || (is_array($segment) && empty($segment))) {
            unset($this->Segment);
        } else {
            $this->Segment = $segment;
        }
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \StructType\Segment $item
     * @return \ArrayType\ArrayOfSegment
     */
    public function addToSegment(\StructType\Segment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Segment) {
            throw new \InvalidArgumentException(sprintf('The Segment property can only contain items of type \StructType\Segment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Segment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Segment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Segment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Segment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Segment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Segment
     */
    public function getAttributeName()
    {
        return 'Segment';
    }
}
