<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XVoiceMailProfile StructType
 * @subpackage Structs
 */
class XVoiceMailProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The voiceMailPilot
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XVmPilot
     */
    public $voiceMailPilot;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: In Update setting isDefault tag as false would not disable this VoiceMailProfile as Default. Instead, the corresponding tag of another VoiceMailProfile should be set to true.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The voiceMailboxMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voiceMailboxMask;
    /**
     * Constructor method for XVoiceMailProfile
     * @uses XVoiceMailProfile::setName()
     * @uses XVoiceMailProfile::setVoiceMailPilot()
     * @uses XVoiceMailProfile::setDescription()
     * @uses XVoiceMailProfile::setIsDefault()
     * @uses XVoiceMailProfile::setVoiceMailboxMask()
     * @param string $name
     * @param \StructType\XVmPilot $voiceMailPilot
     * @param string $description
     * @param string $isDefault
     * @param string $voiceMailboxMask
     */
    public function __construct($name = null, \StructType\XVmPilot $voiceMailPilot = null, $description = null, $isDefault = false, $voiceMailboxMask = null)
    {
        $this
            ->setName($name)
            ->setVoiceMailPilot($voiceMailPilot)
            ->setDescription($description)
            ->setIsDefault($isDefault)
            ->setVoiceMailboxMask($voiceMailboxMask);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XVoiceMailProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get voiceMailPilot value
     * @return \StructType\XVmPilot
     */
    public function getVoiceMailPilot()
    {
        return $this->voiceMailPilot;
    }
    /**
     * Set voiceMailPilot value
     * @param \StructType\XVmPilot $voiceMailPilot
     * @return \StructType\XVoiceMailProfile
     */
    public function setVoiceMailPilot(\StructType\XVmPilot $voiceMailPilot = null)
    {
        $this->voiceMailPilot = $voiceMailPilot;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XVoiceMailProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\XVoiceMailProfile
     */
    public function setIsDefault($isDefault = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get voiceMailboxMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoiceMailboxMask()
    {
        return isset($this->voiceMailboxMask) ? $this->voiceMailboxMask : null;
    }
    /**
     * Set voiceMailboxMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voiceMailboxMask
     * @return \StructType\XVoiceMailProfile
     */
    public function setVoiceMailboxMask($voiceMailboxMask = null)
    {
        // validation for constraint: string
        if (!is_null($voiceMailboxMask) && !is_string($voiceMailboxMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voiceMailboxMask)), __LINE__);
        }
        if (is_null($voiceMailboxMask) || (is_array($voiceMailboxMask) && empty($voiceMailboxMask))) {
            unset($this->voiceMailboxMask);
        } else {
            $this->voiceMailboxMask = $voiceMailboxMask;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XVoiceMailProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
