<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XVoiceMailPilot StructType
 * @subpackage Structs
 */
class XVoiceMailPilot extends AbstractStructBase
{
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $dirn;
    /**
     * The isDefault
     * Meta informations extracted from the WSDL
     * - documentation: In Update setting isDefault tag as false would not disable this VoiceMailPilot as Default. Instead, the corresponding tag of another VoiceMailPilot should be set to true.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The cssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cssName;
    /**
     * Constructor method for XVoiceMailPilot
     * @uses XVoiceMailPilot::setDirn()
     * @uses XVoiceMailPilot::setIsDefault()
     * @uses XVoiceMailPilot::setDescription()
     * @uses XVoiceMailPilot::setCssName()
     * @param string $dirn
     * @param string $isDefault
     * @param string $description
     * @param \StructType\XFkType $cssName
     */
    public function __construct($dirn = null, $isDefault = null, $description = null, \StructType\XFkType $cssName = null)
    {
        $this
            ->setDirn($dirn)
            ->setIsDefault($isDefault)
            ->setDescription($description)
            ->setCssName($cssName);
    }
    /**
     * Get dirn value
     * @return string
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return \StructType\XVoiceMailPilot
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dirn) && strlen($dirn) > 255) || (is_array($dirn) && count($dirn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($dirn) ? strlen($dirn) : count($dirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirn)), __LINE__);
        }
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\XVoiceMailPilot
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XVoiceMailPilot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get cssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCssName()
    {
        return isset($this->cssName) ? $this->cssName : null;
    }
    /**
     * Set cssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cssName
     * @return \StructType\XVoiceMailPilot
     */
    public function setCssName(\StructType\XFkType $cssName = null)
    {
        if (is_null($cssName) || (is_array($cssName) && empty($cssName))) {
            unset($this->cssName);
        } else {
            $this->cssName = $cssName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XVoiceMailPilot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
