<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTranscoder StructType
 * @subpackage Structs
 */
class XTranscoder extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Should not be modified for Cisco Media Termination Point (WS-SVC-CMM).
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified, the special attribute is set to TRUE. Otherwise, the load information is the default for the product.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The subUnit
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: This tag is used only by Cisco Media Termination Point (WS-SVC-CMM) and is a mandatory tag for Cisco Media Termination Point (WS-SVC-CMM) Transcoder. Valid values range from 1 to 4.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subUnit;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - documentation: This tag is used only by Cisco Media Termination Point (WS-SVC-CMM)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The isTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isTrustedRelayPoint;
    /**
     * The maximumCapacity
     * Meta informations extracted from the WSDL
     * - documentation: This tag is mandatory only for Cisco Media Termination Point (WS-SVC-CMM). Valid values for this tag are 32,64,96,128.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maximumCapacity;
    /**
     * Constructor method for XTranscoder
     * @uses XTranscoder::setName()
     * @uses XTranscoder::setProduct()
     * @uses XTranscoder::setDevicePoolName()
     * @uses XTranscoder::setLoadInformation()
     * @uses XTranscoder::setDescription()
     * @uses XTranscoder::setSubUnit()
     * @uses XTranscoder::setCommonDeviceConfigName()
     * @uses XTranscoder::setVendorConfig()
     * @uses XTranscoder::setIsTrustedRelayPoint()
     * @uses XTranscoder::setMaximumCapacity()
     * @param string $name
     * @param string $product
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XLoadInformation $loadInformation
     * @param string $description
     * @param string $subUnit
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param \StructType\XVendorConfig $vendorConfig
     * @param string $isTrustedRelayPoint
     * @param string $maximumCapacity
     */
    public function __construct($name = null, $product = null, \StructType\XFkType $devicePoolName = null, \StructType\XLoadInformation $loadInformation = null, $description = null, $subUnit = '0', \StructType\XFkType $commonDeviceConfigName = null, \StructType\XVendorConfig $vendorConfig = null, $isTrustedRelayPoint = false, $maximumCapacity = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setLoadInformation($loadInformation)
            ->setDescription($description)
            ->setSubUnit($subUnit)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setVendorConfig($vendorConfig)
            ->setIsTrustedRelayPoint($isTrustedRelayPoint)
            ->setMaximumCapacity($maximumCapacity);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XTranscoder
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\XTranscoder
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\XTranscoder
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \StructType\XLoadInformation
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \StructType\XLoadInformation $loadInformation
     * @return \StructType\XTranscoder
     */
    public function setLoadInformation(\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XTranscoder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get subUnit value
     * @return string|null
     */
    public function getSubUnit()
    {
        return $this->subUnit;
    }
    /**
     * Set subUnit value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subUnit
     * @return \StructType\XTranscoder
     */
    public function setSubUnit($subUnit = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($subUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subUnit, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->subUnit = $subUnit;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\XTranscoder
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \StructType\XVendorConfig $vendorConfig
     * @return \StructType\XTranscoder
     */
    public function setVendorConfig(\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get isTrustedRelayPoint value
     * @return string|null
     */
    public function getIsTrustedRelayPoint()
    {
        return $this->isTrustedRelayPoint;
    }
    /**
     * Set isTrustedRelayPoint value
     * @param string $isTrustedRelayPoint
     * @return \StructType\XTranscoder
     */
    public function setIsTrustedRelayPoint($isTrustedRelayPoint = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isTrustedRelayPoint) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isTrustedRelayPoint, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isTrustedRelayPoint) && !is_string($isTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isTrustedRelayPoint)), __LINE__);
        }
        $this->isTrustedRelayPoint = $isTrustedRelayPoint;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maximumCapacity
     * @return \StructType\XTranscoder
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maximumCapacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maximumCapacity, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XTranscoder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
