<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipRealm StructType
 * @subpackage Structs
 */
class XSipRealm extends AbstractStructBase
{
    /**
     * The realm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $realm;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The digestCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $digestCredentials;
    /**
     * Constructor method for XSipRealm
     * @uses XSipRealm::setRealm()
     * @uses XSipRealm::setUserid()
     * @uses XSipRealm::setDigestCredentials()
     * @param string $realm
     * @param string $userid
     * @param string $digestCredentials
     */
    public function __construct($realm = null, $userid = null, $digestCredentials = null)
    {
        $this
            ->setRealm($realm)
            ->setUserid($userid)
            ->setDigestCredentials($digestCredentials);
    }
    /**
     * Get realm value
     * @return string
     */
    public function getRealm()
    {
        return $this->realm;
    }
    /**
     * Set realm value
     * @param string $realm
     * @return \StructType\XSipRealm
     */
    public function setRealm($realm = null)
    {
        // validation for constraint: string
        if (!is_null($realm) && !is_string($realm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($realm)), __LINE__);
        }
        $this->realm = $realm;
        return $this;
    }
    /**
     * Get userid value
     * @return string
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\XSipRealm
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \StructType\XSipRealm
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($digestCredentials) && !is_string($digestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestCredentials)), __LINE__);
        }
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XSipRealm
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
