<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRouteList StructType
 * @subpackage Structs
 */
class XRouteList extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The callManagerGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The routeListEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeListEnabled;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The runOnEveryNode
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runOnEveryNode;
    /**
     * Constructor method for XRouteList
     * @uses XRouteList::setName()
     * @uses XRouteList::setCallManagerGroupName()
     * @uses XRouteList::setDescription()
     * @uses XRouteList::setRouteListEnabled()
     * @uses XRouteList::setMembers()
     * @uses XRouteList::setRunOnEveryNode()
     * @param string $name
     * @param \StructType\XFkType $callManagerGroupName
     * @param string $description
     * @param string $routeListEnabled
     * @param \StructType\Members $members
     * @param string $runOnEveryNode
     */
    public function __construct($name = null, \StructType\XFkType $callManagerGroupName = null, $description = null, $routeListEnabled = false, \StructType\Members $members = null, $runOnEveryNode = false)
    {
        $this
            ->setName($name)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setDescription($description)
            ->setRouteListEnabled($routeListEnabled)
            ->setMembers($members)
            ->setRunOnEveryNode($runOnEveryNode);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XRouteList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \StructType\XFkType
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \StructType\XFkType $callManagerGroupName
     * @return \StructType\XRouteList
     */
    public function setCallManagerGroupName(\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XRouteList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get routeListEnabled value
     * @return string|null
     */
    public function getRouteListEnabled()
    {
        return $this->routeListEnabled;
    }
    /**
     * Set routeListEnabled value
     * @param string $routeListEnabled
     * @return \StructType\XRouteList
     */
    public function setRouteListEnabled($routeListEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($routeListEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($routeListEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeListEnabled) && !is_string($routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeListEnabled)), __LINE__);
        }
        $this->routeListEnabled = $routeListEnabled;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\XRouteList
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get runOnEveryNode value
     * @return string|null
     */
    public function getRunOnEveryNode()
    {
        return $this->runOnEveryNode;
    }
    /**
     * Set runOnEveryNode value
     * @param string $runOnEveryNode
     * @return \StructType\XRouteList
     */
    public function setRunOnEveryNode($runOnEveryNode = false)
    {
        // validation for constraint: pattern
        if (is_scalar($runOnEveryNode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($runOnEveryNode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($runOnEveryNode) && !is_string($runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runOnEveryNode)), __LINE__);
        }
        $this->runOnEveryNode = $runOnEveryNode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XRouteList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
