<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMobility StructType
 * @subpackage Structs
 */
class XMobility extends AbstractStructBase
{
    /**
     * The handoffNumber
     * @var string
     */
    public $handoffNumber;
    /**
     * The handoffPartitionName
     * Meta informations extracted from the WSDL
     * - documentation: Default Partition would be Null in case not specified.
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $handoffPartitionName;
    /**
     * The DTMFNumber
     * @var string
     */
    public $DTMFNumber;
    /**
     * The DTMFPartitionName
     * Meta informations extracted from the WSDL
     * - documentation: Default Partition would be Null in case not specified.
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $DTMFPartitionName;
    /**
     * Constructor method for XMobility
     * @uses XMobility::setHandoffNumber()
     * @uses XMobility::setHandoffPartitionName()
     * @uses XMobility::setDTMFNumber()
     * @uses XMobility::setDTMFPartitionName()
     * @param string $handoffNumber
     * @param \StructType\XFkType $handoffPartitionName
     * @param string $dTMFNumber
     * @param \StructType\XFkType $dTMFPartitionName
     */
    public function __construct($handoffNumber = null, \StructType\XFkType $handoffPartitionName = null, $dTMFNumber = null, \StructType\XFkType $dTMFPartitionName = null)
    {
        $this
            ->setHandoffNumber($handoffNumber)
            ->setHandoffPartitionName($handoffPartitionName)
            ->setDTMFNumber($dTMFNumber)
            ->setDTMFPartitionName($dTMFPartitionName);
    }
    /**
     * Get handoffNumber value
     * @return string|null
     */
    public function getHandoffNumber()
    {
        return $this->handoffNumber;
    }
    /**
     * Set handoffNumber value
     * @param string $handoffNumber
     * @return \StructType\XMobility
     */
    public function setHandoffNumber($handoffNumber = null)
    {
        // validation for constraint: string
        if (!is_null($handoffNumber) && !is_string($handoffNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($handoffNumber)), __LINE__);
        }
        $this->handoffNumber = $handoffNumber;
        return $this;
    }
    /**
     * Get handoffPartitionName value
     * @return \StructType\XFkType|null
     */
    public function getHandoffPartitionName()
    {
        return $this->handoffPartitionName;
    }
    /**
     * Set handoffPartitionName value
     * @param \StructType\XFkType $handoffPartitionName
     * @return \StructType\XMobility
     */
    public function setHandoffPartitionName(\StructType\XFkType $handoffPartitionName = null)
    {
        $this->handoffPartitionName = $handoffPartitionName;
        return $this;
    }
    /**
     * Get DTMFNumber value
     * @return string|null
     */
    public function getDTMFNumber()
    {
        return $this->DTMFNumber;
    }
    /**
     * Set DTMFNumber value
     * @param string $dTMFNumber
     * @return \StructType\XMobility
     */
    public function setDTMFNumber($dTMFNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dTMFNumber) && !is_string($dTMFNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dTMFNumber)), __LINE__);
        }
        $this->DTMFNumber = $dTMFNumber;
        return $this;
    }
    /**
     * Get DTMFPartitionName value
     * @return \StructType\XFkType|null
     */
    public function getDTMFPartitionName()
    {
        return $this->DTMFPartitionName;
    }
    /**
     * Set DTMFPartitionName value
     * @param \StructType\XFkType $dTMFPartitionName
     * @return \StructType\XMobility
     */
    public function setDTMFPartitionName(\StructType\XFkType $dTMFPartitionName = null)
    {
        $this->DTMFPartitionName = $dTMFPartitionName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XMobility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
