<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMediaResourceGroup StructType
 * @subpackage Structs
 */
class XMediaResourceGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The multicast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Members
     */
    public $members;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * Constructor method for XMediaResourceGroup
     * @uses XMediaResourceGroup::setName()
     * @uses XMediaResourceGroup::setMulticast()
     * @uses XMediaResourceGroup::setMembers()
     * @uses XMediaResourceGroup::setDescription()
     * @param string $name
     * @param string $multicast
     * @param \StructType\Members $members
     * @param string $description
     */
    public function __construct($name = null, $multicast = null, \StructType\Members $members = null, $description = null)
    {
        $this
            ->setName($name)
            ->setMulticast($multicast)
            ->setMembers($members)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XMediaResourceGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get multicast value
     * @return string
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \StructType\XMediaResourceGroup
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: pattern
        if (is_scalar($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($multicast, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multicast)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\XMediaResourceGroup
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XMediaResourceGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XMediaResourceGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
