<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLocationBetween StructType
 * @subpackage Structs
 */
class XLocationBetween extends AbstractStructBase
{
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - default: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $weight;
    /**
     * The audioBandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $audioBandwidth;
    /**
     * The videoBandwidth
     * Meta informations extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $videoBandwidth;
    /**
     * The immersiveBandwidth
     * Meta informations extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $immersiveBandwidth;
    /**
     * Constructor method for XLocationBetween
     * @uses XLocationBetween::setLocationName()
     * @uses XLocationBetween::setWeight()
     * @uses XLocationBetween::setAudioBandwidth()
     * @uses XLocationBetween::setVideoBandwidth()
     * @uses XLocationBetween::setImmersiveBandwidth()
     * @param \StructType\XFkType $locationName
     * @param string $weight
     * @param string $audioBandwidth
     * @param string $videoBandwidth
     * @param string $immersiveBandwidth
     */
    public function __construct(\StructType\XFkType $locationName = null, $weight = '50', $audioBandwidth = null, $videoBandwidth = '384', $immersiveBandwidth = '384')
    {
        $this
            ->setLocationName($locationName)
            ->setWeight($weight)
            ->setAudioBandwidth($audioBandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setImmersiveBandwidth($immersiveBandwidth);
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\XLocationBetween
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get weight value
     * @return string
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weight
     * @return \StructType\XLocationBetween
     */
    public function setWeight($weight = '50')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($weight)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $weight, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get audioBandwidth value
     * @return string
     */
    public function getAudioBandwidth()
    {
        return $this->audioBandwidth;
    }
    /**
     * Set audioBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audioBandwidth
     * @return \StructType\XLocationBetween
     */
    public function setAudioBandwidth($audioBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($audioBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audioBandwidth, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->audioBandwidth = $audioBandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return \StructType\XLocationBetween
     */
    public function setVideoBandwidth($videoBandwidth = '384')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoBandwidth, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get immersiveBandwidth value
     * @return string
     */
    public function getImmersiveBandwidth()
    {
        return $this->immersiveBandwidth;
    }
    /**
     * Set immersiveBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $immersiveBandwidth
     * @return \StructType\XLocationBetween
     */
    public function setImmersiveBandwidth($immersiveBandwidth = '384')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($immersiveBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $immersiveBandwidth, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->immersiveBandwidth = $immersiveBandwidth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XLocationBetween
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
