<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLdapSyncCustomField StructType
 * @subpackage Structs
 */
class XLdapSyncCustomField extends AbstractStructBase
{
    /**
     * The ldapConfigurationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapConfigurationName;
    /**
     * The customUserField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $customUserField;
    /**
     * The ldapUserField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapUserField;
    /**
     * Constructor method for XLdapSyncCustomField
     * @uses XLdapSyncCustomField::setLdapConfigurationName()
     * @uses XLdapSyncCustomField::setCustomUserField()
     * @uses XLdapSyncCustomField::setLdapUserField()
     * @param string $ldapConfigurationName
     * @param string $customUserField
     * @param string $ldapUserField
     */
    public function __construct($ldapConfigurationName = null, $customUserField = null, $ldapUserField = null)
    {
        $this
            ->setLdapConfigurationName($ldapConfigurationName)
            ->setCustomUserField($customUserField)
            ->setLdapUserField($ldapUserField);
    }
    /**
     * Get ldapConfigurationName value
     * @return string
     */
    public function getLdapConfigurationName()
    {
        return $this->ldapConfigurationName;
    }
    /**
     * Set ldapConfigurationName value
     * @param string $ldapConfigurationName
     * @return \StructType\XLdapSyncCustomField
     */
    public function setLdapConfigurationName($ldapConfigurationName = null)
    {
        // validation for constraint: string
        if (!is_null($ldapConfigurationName) && !is_string($ldapConfigurationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapConfigurationName)), __LINE__);
        }
        $this->ldapConfigurationName = $ldapConfigurationName;
        return $this;
    }
    /**
     * Get customUserField value
     * @return string
     */
    public function getCustomUserField()
    {
        return $this->customUserField;
    }
    /**
     * Set customUserField value
     * @param string $customUserField
     * @return \StructType\XLdapSyncCustomField
     */
    public function setCustomUserField($customUserField = null)
    {
        // validation for constraint: string
        if (!is_null($customUserField) && !is_string($customUserField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customUserField)), __LINE__);
        }
        $this->customUserField = $customUserField;
        return $this;
    }
    /**
     * Get ldapUserField value
     * @return string
     */
    public function getLdapUserField()
    {
        return $this->ldapUserField;
    }
    /**
     * Set ldapUserField value
     * @param string $ldapUserField
     * @return \StructType\XLdapSyncCustomField
     */
    public function setLdapUserField($ldapUserField = null)
    {
        // validation for constraint: string
        if (!is_null($ldapUserField) && !is_string($ldapUserField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapUserField)), __LINE__);
        }
        $this->ldapUserField = $ldapUserField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XLdapSyncCustomField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
