<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImportedDirectoryUriCatalogs StructType
 * @subpackage Structs
 */
class XImportedDirectoryUriCatalogs extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The routeString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $routeString;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The lastLoadedFileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $lastLoadedFileName;
    /**
     * The fileLoadDateTime
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fileLoadDateTime;
    /**
     * Constructor method for XImportedDirectoryUriCatalogs
     * @uses XImportedDirectoryUriCatalogs::setName()
     * @uses XImportedDirectoryUriCatalogs::setRouteString()
     * @uses XImportedDirectoryUriCatalogs::setDescription()
     * @uses XImportedDirectoryUriCatalogs::setLastLoadedFileName()
     * @uses XImportedDirectoryUriCatalogs::setFileLoadDateTime()
     * @param string $name
     * @param string $routeString
     * @param string $description
     * @param string $lastLoadedFileName
     * @param string $fileLoadDateTime
     */
    public function __construct($name = null, $routeString = null, $description = null, $lastLoadedFileName = null, $fileLoadDateTime = '0')
    {
        $this
            ->setName($name)
            ->setRouteString($routeString)
            ->setDescription($description)
            ->setLastLoadedFileName($lastLoadedFileName)
            ->setFileLoadDateTime($fileLoadDateTime);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XImportedDirectoryUriCatalogs
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get routeString value
     * @return string
     */
    public function getRouteString()
    {
        return $this->routeString;
    }
    /**
     * Set routeString value
     * @param string $routeString
     * @return \StructType\XImportedDirectoryUriCatalogs
     */
    public function setRouteString($routeString = null)
    {
        // validation for constraint: string
        if (!is_null($routeString) && !is_string($routeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeString)), __LINE__);
        }
        $this->routeString = $routeString;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\XImportedDirectoryUriCatalogs
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get lastLoadedFileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastLoadedFileName()
    {
        return isset($this->lastLoadedFileName) ? $this->lastLoadedFileName : null;
    }
    /**
     * Set lastLoadedFileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastLoadedFileName
     * @return \StructType\XImportedDirectoryUriCatalogs
     */
    public function setLastLoadedFileName($lastLoadedFileName = null)
    {
        // validation for constraint: string
        if (!is_null($lastLoadedFileName) && !is_string($lastLoadedFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastLoadedFileName)), __LINE__);
        }
        if (is_null($lastLoadedFileName) || (is_array($lastLoadedFileName) && empty($lastLoadedFileName))) {
            unset($this->lastLoadedFileName);
        } else {
            $this->lastLoadedFileName = $lastLoadedFileName;
        }
        return $this;
    }
    /**
     * Get fileLoadDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileLoadDateTime()
    {
        return isset($this->fileLoadDateTime) ? $this->fileLoadDateTime : null;
    }
    /**
     * Set fileLoadDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileLoadDateTime
     * @return \StructType\XImportedDirectoryUriCatalogs
     */
    public function setFileLoadDateTime($fileLoadDateTime = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($fileLoadDateTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fileLoadDateTime, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($fileLoadDateTime) || (is_array($fileLoadDateTime) && empty($fileLoadDateTime))) {
            unset($this->fileLoadDateTime);
        } else {
            $this->fileLoadDateTime = $fileLoadDateTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XImportedDirectoryUriCatalogs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
