<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XHuntListMember StructType
 * @subpackage Structs
 */
class XHuntListMember extends AbstractStructBase
{
    /**
     * The lineGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $lineGroupName;
    /**
     * The selectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for XHuntListMember
     * @uses XHuntListMember::setLineGroupName()
     * @uses XHuntListMember::setSelectionOrder()
     * @param \StructType\XFkType $lineGroupName
     * @param string $selectionOrder
     */
    public function __construct(\StructType\XFkType $lineGroupName = null, $selectionOrder = null)
    {
        $this
            ->setLineGroupName($lineGroupName)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get lineGroupName value
     * @return \StructType\XFkType
     */
    public function getLineGroupName()
    {
        return $this->lineGroupName;
    }
    /**
     * Set lineGroupName value
     * @param \StructType\XFkType $lineGroupName
     * @return \StructType\XHuntListMember
     */
    public function setLineGroupName(\StructType\XFkType $lineGroupName = null)
    {
        $this->lineGroupName = $lineGroupName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\XHuntListMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionOrder, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XHuntListMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
