<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XH323Gateway StructType
 * @subpackage Structs
 */
class XH323Gateway extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - default: User
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The tunneledProtocol
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $tunneledProtocol;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The callingPartySelection
     * Meta informations extracted from the WSDL
     * - default: Originator
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingLineIdPresentation
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The signalingPort
     * Meta informations extracted from the WSDL
     * - default: 1720
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $signalingPort;
    /**
     * The calledPartyIeNumberType
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $calledPartyIeNumberType;
    /**
     * The callingPartyIeNumberType
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callingPartyIeNumberType;
    /**
     * The calledNumberingPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $calledNumberingPlan;
    /**
     * The callingNumberingPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callingNumberingPlan;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The asn1RoseOidEncoding
     * Meta informations extracted from the WSDL
     * - default: No Changes
     * - documentation: Applicable for only if PRI variant is QSIG
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The qsigVariant
     * Meta informations extracted from the WSDL
     * - default: No Changes
     * - documentation: Applicable for only PRI variant is QSIG
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $qsigVariant;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The pathReplacementSupport
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pathReplacementSupport;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The srtpAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: When this flag is checked, IPSec needs to be configured in the network to provide end to end security. Failure to do so will expose keys and other information
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The waitForFarEndH245TerminalSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $waitForFarEndH245TerminalSet;
    /**
     * The mtpRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $callerIdDn;
    /**
     * The enableInboundFaststart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableInboundFaststart;
    /**
     * The enableOutboundFaststart
     * Meta informations extracted from the WSDL
     * - documentation: If set to True,mediaResourceList must be mentioned and mtpRequired must be set to True.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableOutboundFaststart;
    /**
     * The codecForOutboundFaststart
     * Meta informations extracted from the WSDL
     * - default: G711 u-law 64K
     * - documentation: enableOutboundFaststart must be set to true for it to be read.Not Nillable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codecForOutboundFaststart;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The allowH235PassThrough
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowH235PassThrough;
    /**
     * The sigDigits
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The prefixDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $prefixDn;
    /**
     * The callingPartyNationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $callingPartyNationalPrefix;
    /**
     * The callingPartyInternationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $callingPartyInternationalPrefix;
    /**
     * The callingPartyUnknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $callingPartyUnknownPrefix;
    /**
     * The callingPartySubscriberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $callingPartySubscriberPrefix;
    /**
     * The callingPartyNationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyNationalStripDigits;
    /**
     * The callingPartyInternationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyInternationalStripDigits;
    /**
     * The callingPartyUnknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyUnknownStripDigits;
    /**
     * The callingPartySubscriberStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartySubscriberStripDigits;
    /**
     * The callingPartyNationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyNationalTransformationCssName;
    /**
     * The callingPartyInternationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyInternationalTransformationCssName;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The callingPartySubscriberTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartySubscriberTransformationCssName;
    /**
     * The calledPartyNationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The displayIeDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayIeDelivery;
    /**
     * The redirectOutboundNumberIe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The redirectInboundNumberIe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The useDevicePoolCalledCssNatl
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssNatl;
    /**
     * The useDevicePoolCalledCssIntl
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssIntl;
    /**
     * The useDevicePoolCalledCssUnkn
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssUnkn;
    /**
     * The useDevicePoolCalledCssSubs
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssSubs;
    /**
     * The useDevicePoolCntdPnTransformationCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCntdPnTransformationCss;
    /**
     * The cntdPnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The redirectingPartyTransformationCSS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $redirectingPartyTransformationCSS;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XH323Gateway
     * @uses XH323Gateway::setName()
     * @uses XH323Gateway::setProduct()
     * @uses XH323Gateway::setClass()
     * @uses XH323Gateway::setProtocol()
     * @uses XH323Gateway::setProtocolSide()
     * @uses XH323Gateway::setDevicePoolName()
     * @uses XH323Gateway::setLocationName()
     * @uses XH323Gateway::setTunneledProtocol()
     * @uses XH323Gateway::setUseTrustedRelayPoint()
     * @uses XH323Gateway::setPacketCaptureMode()
     * @uses XH323Gateway::setCallingPartySelection()
     * @uses XH323Gateway::setCallingLineIdPresentation()
     * @uses XH323Gateway::setSignalingPort()
     * @uses XH323Gateway::setCalledPartyIeNumberType()
     * @uses XH323Gateway::setCallingPartyIeNumberType()
     * @uses XH323Gateway::setCalledNumberingPlan()
     * @uses XH323Gateway::setCallingNumberingPlan()
     * @uses XH323Gateway::setDescription()
     * @uses XH323Gateway::setCallingSearchSpaceName()
     * @uses XH323Gateway::setCommonDeviceConfigName()
     * @uses XH323Gateway::setNetworkLocation()
     * @uses XH323Gateway::setMediaResourceListName()
     * @uses XH323Gateway::setAutomatedAlternateRoutingCssName()
     * @uses XH323Gateway::setAarNeighborhoodName()
     * @uses XH323Gateway::setLoadInformation()
     * @uses XH323Gateway::setAsn1RoseOidEncoding()
     * @uses XH323Gateway::setQsigVariant()
     * @uses XH323Gateway::setVendorConfig()
     * @uses XH323Gateway::setPathReplacementSupport()
     * @uses XH323Gateway::setTraceFlag()
     * @uses XH323Gateway::setMlppDomainId()
     * @uses XH323Gateway::setRetryVideoCallAsAudio()
     * @uses XH323Gateway::setCgpnTransformationCssName()
     * @uses XH323Gateway::setUseDevicePoolCgpnTransformCss()
     * @uses XH323Gateway::setGeoLocationName()
     * @uses XH323Gateway::setGeoLocationFilterName()
     * @uses XH323Gateway::setCdpnTransformationCssName()
     * @uses XH323Gateway::setUseDevicePoolCdpnTransformCss()
     * @uses XH323Gateway::setPacketCaptureDuration()
     * @uses XH323Gateway::setSrtpAllowed()
     * @uses XH323Gateway::setWaitForFarEndH245TerminalSet()
     * @uses XH323Gateway::setMtpRequired()
     * @uses XH323Gateway::setCallerIdDn()
     * @uses XH323Gateway::setEnableInboundFaststart()
     * @uses XH323Gateway::setEnableOutboundFaststart()
     * @uses XH323Gateway::setCodecForOutboundFaststart()
     * @uses XH323Gateway::setTransmitUtf8()
     * @uses XH323Gateway::setAllowH235PassThrough()
     * @uses XH323Gateway::setSigDigits()
     * @uses XH323Gateway::setPrefixDn()
     * @uses XH323Gateway::setCallingPartyNationalPrefix()
     * @uses XH323Gateway::setCallingPartyInternationalPrefix()
     * @uses XH323Gateway::setCallingPartyUnknownPrefix()
     * @uses XH323Gateway::setCallingPartySubscriberPrefix()
     * @uses XH323Gateway::setCallingPartyNationalStripDigits()
     * @uses XH323Gateway::setCallingPartyInternationalStripDigits()
     * @uses XH323Gateway::setCallingPartyUnknownStripDigits()
     * @uses XH323Gateway::setCallingPartySubscriberStripDigits()
     * @uses XH323Gateway::setCallingPartyNationalTransformationCssName()
     * @uses XH323Gateway::setCallingPartyInternationalTransformationCssName()
     * @uses XH323Gateway::setCallingPartyUnknownTransformationCssName()
     * @uses XH323Gateway::setCallingPartySubscriberTransformationCssName()
     * @uses XH323Gateway::setCalledPartyNationalPrefix()
     * @uses XH323Gateway::setCalledPartyInternationalPrefix()
     * @uses XH323Gateway::setCalledPartyUnknownPrefix()
     * @uses XH323Gateway::setCalledPartySubscriberPrefix()
     * @uses XH323Gateway::setCalledPartyNationalStripDigits()
     * @uses XH323Gateway::setCalledPartyInternationalStripDigits()
     * @uses XH323Gateway::setCalledPartyUnknownStripDigits()
     * @uses XH323Gateway::setCalledPartySubscriberStripDigits()
     * @uses XH323Gateway::setCalledPartyNationalTransformationCssName()
     * @uses XH323Gateway::setCalledPartyInternationalTransformationCssName()
     * @uses XH323Gateway::setCalledPartyUnknownTransformationCssName()
     * @uses XH323Gateway::setCalledPartySubscriberTransformationCssName()
     * @uses XH323Gateway::setPstnAccess()
     * @uses XH323Gateway::setImeE164TransformationName()
     * @uses XH323Gateway::setDisplayIeDelivery()
     * @uses XH323Gateway::setRedirectOutboundNumberIe()
     * @uses XH323Gateway::setRedirectInboundNumberIe()
     * @uses XH323Gateway::setUseDevicePoolCgpnTransformCssNatl()
     * @uses XH323Gateway::setUseDevicePoolCgpnTransformCssIntl()
     * @uses XH323Gateway::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses XH323Gateway::setUseDevicePoolCgpnTransformCssSubs()
     * @uses XH323Gateway::setUseDevicePoolCalledCssNatl()
     * @uses XH323Gateway::setUseDevicePoolCalledCssIntl()
     * @uses XH323Gateway::setUseDevicePoolCalledCssUnkn()
     * @uses XH323Gateway::setUseDevicePoolCalledCssSubs()
     * @uses XH323Gateway::setUseDevicePoolCntdPnTransformationCss()
     * @uses XH323Gateway::setCntdPnTransformationCssName()
     * @uses XH323Gateway::setConfidentialAccess()
     * @uses XH323Gateway::setRedirectingPartyTransformationCSS()
     * @uses XH323Gateway::setCtiid()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $locationName
     * @param string $tunneledProtocol
     * @param string $useTrustedRelayPoint
     * @param string $packetCaptureMode
     * @param string $callingPartySelection
     * @param string $callingLineIdPresentation
     * @param string $signalingPort
     * @param string $calledPartyIeNumberType
     * @param string $callingPartyIeNumberType
     * @param string $calledNumberingPlan
     * @param string $callingNumberingPlan
     * @param string $description
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \StructType\XFkType $mediaResourceListName
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param \StructType\XLoadInformation $loadInformation
     * @param string $asn1RoseOidEncoding
     * @param string $qsigVariant
     * @param \StructType\XVendorConfig $vendorConfig
     * @param string $pathReplacementSupport
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $retryVideoCallAsAudio
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \StructType\XFkType $geoLocationName
     * @param \StructType\XFkType $geoLocationFilterName
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $packetCaptureDuration
     * @param string $srtpAllowed
     * @param string $waitForFarEndH245TerminalSet
     * @param string $mtpRequired
     * @param string $callerIdDn
     * @param string $enableInboundFaststart
     * @param string $enableOutboundFaststart
     * @param string $codecForOutboundFaststart
     * @param string $transmitUtf8
     * @param string $allowH235PassThrough
     * @param \StructType\SigDigits $sigDigits
     * @param string $prefixDn
     * @param string $callingPartyNationalPrefix
     * @param string $callingPartyInternationalPrefix
     * @param string $callingPartyUnknownPrefix
     * @param string $callingPartySubscriberPrefix
     * @param string $callingPartyNationalStripDigits
     * @param string $callingPartyInternationalStripDigits
     * @param string $callingPartyUnknownStripDigits
     * @param string $callingPartySubscriberStripDigits
     * @param \StructType\XFkType $callingPartyNationalTransformationCssName
     * @param \StructType\XFkType $callingPartyInternationalTransformationCssName
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @param \StructType\XFkType $callingPartySubscriberTransformationCssName
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param string $pstnAccess
     * @param \StructType\XFkType $imeE164TransformationName
     * @param string $displayIeDelivery
     * @param string $redirectOutboundNumberIe
     * @param string $redirectInboundNumberIe
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $useDevicePoolCalledCssNatl
     * @param string $useDevicePoolCalledCssIntl
     * @param string $useDevicePoolCalledCssUnkn
     * @param string $useDevicePoolCalledCssSubs
     * @param string $useDevicePoolCntdPnTransformationCss
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param \StructType\XFkType $redirectingPartyTransformationCSS
     * @param int $ctiid
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \StructType\XFkType $devicePoolName = null, \StructType\XFkType $locationName = null, $tunneledProtocol = 'None', $useTrustedRelayPoint = 'Default', $packetCaptureMode = 'None', $callingPartySelection = 'Originator', $callingLineIdPresentation = 'Default', $signalingPort = '1720', $calledPartyIeNumberType = 'Cisco CallManager', $callingPartyIeNumberType = 'Cisco CallManager', $calledNumberingPlan = 'Cisco CallManager', $callingNumberingPlan = 'Cisco CallManager', $description = null, \StructType\XFkType $callingSearchSpaceName = null, \StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \StructType\XFkType $mediaResourceListName = null, \StructType\XFkType $automatedAlternateRoutingCssName = null, \StructType\XFkType $aarNeighborhoodName = null, \StructType\XLoadInformation $loadInformation = null, $asn1RoseOidEncoding = 'No Changes', $qsigVariant = 'No Changes', \StructType\XVendorConfig $vendorConfig = null, $pathReplacementSupport = false, $traceFlag = null, $mlppDomainId = null, $retryVideoCallAsAudio = true, \StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = true, \StructType\XFkType $geoLocationName = null, \StructType\XFkType $geoLocationFilterName = null, \StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = true, $packetCaptureDuration = '0', $srtpAllowed = false, $waitForFarEndH245TerminalSet = null, $mtpRequired = null, $callerIdDn = null, $enableInboundFaststart = null, $enableOutboundFaststart = null, $codecForOutboundFaststart = 'G711 u-law 64K', $transmitUtf8 = false, $allowH235PassThrough = false, \StructType\SigDigits $sigDigits = '0', $prefixDn = null, $callingPartyNationalPrefix = null, $callingPartyInternationalPrefix = null, $callingPartyUnknownPrefix = null, $callingPartySubscriberPrefix = null, $callingPartyNationalStripDigits = null, $callingPartyInternationalStripDigits = null, $callingPartyUnknownStripDigits = null, $callingPartySubscriberStripDigits = null, \StructType\XFkType $callingPartyNationalTransformationCssName = null, \StructType\XFkType $callingPartyInternationalTransformationCssName = null, \StructType\XFkType $callingPartyUnknownTransformationCssName = null, \StructType\XFkType $callingPartySubscriberTransformationCssName = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \StructType\XFkType $calledPartyNationalTransformationCssName = null, \StructType\XFkType $calledPartyInternationalTransformationCssName = null, \StructType\XFkType $calledPartyUnknownTransformationCssName = null, \StructType\XFkType $calledPartySubscriberTransformationCssName = null, $pstnAccess = true, \StructType\XFkType $imeE164TransformationName = null, $displayIeDelivery = null, $redirectOutboundNumberIe = null, $redirectInboundNumberIe = null, $useDevicePoolCgpnTransformCssNatl = true, $useDevicePoolCgpnTransformCssIntl = true, $useDevicePoolCgpnTransformCssUnkn = true, $useDevicePoolCgpnTransformCssSubs = true, $useDevicePoolCalledCssNatl = true, $useDevicePoolCalledCssIntl = true, $useDevicePoolCalledCssUnkn = true, $useDevicePoolCalledCssSubs = true, $useDevicePoolCntdPnTransformationCss = true, \StructType\XFkType $cntdPnTransformationCssName = null, \StructType\ConfidentialAccess $confidentialAccess = null, \StructType\XFkType $redirectingPartyTransformationCSS = null, $ctiid = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setTunneledProtocol($tunneledProtocol)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setSignalingPort($signalingPort)
            ->setCalledPartyIeNumberType($calledPartyIeNumberType)
            ->setCallingPartyIeNumberType($callingPartyIeNumberType)
            ->setCalledNumberingPlan($calledNumberingPlan)
            ->setCallingNumberingPlan($callingNumberingPlan)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQsigVariant($qsigVariant)
            ->setVendorConfig($vendorConfig)
            ->setPathReplacementSupport($pathReplacementSupport)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSrtpAllowed($srtpAllowed)
            ->setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet)
            ->setMtpRequired($mtpRequired)
            ->setCallerIdDn($callerIdDn)
            ->setEnableInboundFaststart($enableInboundFaststart)
            ->setEnableOutboundFaststart($enableOutboundFaststart)
            ->setCodecForOutboundFaststart($codecForOutboundFaststart)
            ->setTransmitUtf8($transmitUtf8)
            ->setAllowH235PassThrough($allowH235PassThrough)
            ->setSigDigits($sigDigits)
            ->setPrefixDn($prefixDn)
            ->setCallingPartyNationalPrefix($callingPartyNationalPrefix)
            ->setCallingPartyInternationalPrefix($callingPartyInternationalPrefix)
            ->setCallingPartyUnknownPrefix($callingPartyUnknownPrefix)
            ->setCallingPartySubscriberPrefix($callingPartySubscriberPrefix)
            ->setCallingPartyNationalStripDigits($callingPartyNationalStripDigits)
            ->setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits)
            ->setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits)
            ->setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits)
            ->setCallingPartyNationalTransformationCssName($callingPartyNationalTransformationCssName)
            ->setCallingPartyInternationalTransformationCssName($callingPartyInternationalTransformationCssName)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setCallingPartySubscriberTransformationCssName($callingPartySubscriberTransformationCssName)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setDisplayIeDelivery($displayIeDelivery)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl)
            ->setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl)
            ->setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn)
            ->setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs)
            ->setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setConfidentialAccess($confidentialAccess)
            ->setRedirectingPartyTransformationCSS($redirectingPartyTransformationCSS)
            ->setCtiid($ctiid);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XH323Gateway
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\XH323Gateway
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \EnumType\XClass::valueIsValid()
     * @uses \EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\XH323Gateway
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \EnumType\XDeviceProtocol::valueIsValid()
     * @uses \EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \StructType\XH323Gateway
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \EnumType\XProtocolSide::valueIsValid()
     * @uses \EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \StructType\XH323Gateway
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\XH323Gateway
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\XH323Gateway
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get tunneledProtocol value
     * @return string
     */
    public function getTunneledProtocol()
    {
        return $this->tunneledProtocol;
    }
    /**
     * Set tunneledProtocol value
     * @uses \EnumType\XTunneledProtocol::valueIsValid()
     * @uses \EnumType\XTunneledProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tunneledProtocol
     * @return \StructType\XH323Gateway
     */
    public function setTunneledProtocol($tunneledProtocol = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTunneledProtocol::valueIsValid($tunneledProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tunneledProtocol, implode(', ', \EnumType\XTunneledProtocol::getValidValues())), __LINE__);
        }
        $this->tunneledProtocol = $tunneledProtocol;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\XH323Gateway
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \StructType\XH323Gateway
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', \EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \EnumType\XCallingPartySelection::valueIsValid()
     * @uses \EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartySelection($callingPartySelection = 'Originator')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySelection, implode(', ', \EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdPresentation
     * @return \StructType\XH323Gateway
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($callingLineIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLineIdPresentation, implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get signalingPort value
     * @return string
     */
    public function getSignalingPort()
    {
        return $this->signalingPort;
    }
    /**
     * Set signalingPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $signalingPort
     * @return \StructType\XH323Gateway
     */
    public function setSignalingPort($signalingPort = '1720')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($signalingPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $signalingPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->signalingPort = $signalingPort;
        return $this;
    }
    /**
     * Get calledPartyIeNumberType value
     * @return string
     */
    public function getCalledPartyIeNumberType()
    {
        return $this->calledPartyIeNumberType;
    }
    /**
     * Set calledPartyIeNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyIeNumberType
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyIeNumberType($calledPartyIeNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($calledPartyIeNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyIeNumberType, implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyIeNumberType = $calledPartyIeNumberType;
        return $this;
    }
    /**
     * Get callingPartyIeNumberType value
     * @return string
     */
    public function getCallingPartyIeNumberType()
    {
        return $this->callingPartyIeNumberType;
    }
    /**
     * Set callingPartyIeNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyIeNumberType
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyIeNumberType($callingPartyIeNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($callingPartyIeNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyIeNumberType, implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyIeNumberType = $callingPartyIeNumberType;
        return $this;
    }
    /**
     * Get calledNumberingPlan value
     * @return string
     */
    public function getCalledNumberingPlan()
    {
        return $this->calledNumberingPlan;
    }
    /**
     * Set calledNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledNumberingPlan
     * @return \StructType\XH323Gateway
     */
    public function setCalledNumberingPlan($calledNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($calledNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledNumberingPlan, implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledNumberingPlan = $calledNumberingPlan;
        return $this;
    }
    /**
     * Get callingNumberingPlan value
     * @return string
     */
    public function getCallingNumberingPlan()
    {
        return $this->callingNumberingPlan;
    }
    /**
     * Set callingNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNumberingPlan
     * @return \StructType\XH323Gateway
     */
    public function setCallingNumberingPlan($callingNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($callingNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingNumberingPlan, implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingNumberingPlan = $callingNumberingPlan;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XH323Gateway
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\XH323Gateway
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\XH323Gateway
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \EnumType\XNetworkLocation::valueIsValid()
     * @uses \EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \StructType\XH323Gateway
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', \EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mediaResourceListName
     * @return \StructType\XH323Gateway
     */
    public function setMediaResourceListName(\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\XH323Gateway
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\XH323Gateway
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XLoadInformation $loadInformation
     * @return \StructType\XH323Gateway
     */
    public function setLoadInformation(\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @uses \EnumType\XASN1RoseOidEncoding::valueIsValid()
     * @uses \EnumType\XASN1RoseOidEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asn1RoseOidEncoding
     * @return \StructType\XH323Gateway
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XASN1RoseOidEncoding::valueIsValid($asn1RoseOidEncoding)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $asn1RoseOidEncoding, implode(', ', \EnumType\XASN1RoseOidEncoding::getValidValues())), __LINE__);
        }
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get qsigVariant value
     * @return string|null
     */
    public function getQsigVariant()
    {
        return $this->qsigVariant;
    }
    /**
     * Set qsigVariant value
     * @uses \EnumType\XQSIGVariant::valueIsValid()
     * @uses \EnumType\XQSIGVariant::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qsigVariant
     * @return \StructType\XH323Gateway
     */
    public function setQsigVariant($qsigVariant = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XQSIGVariant::valueIsValid($qsigVariant)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qsigVariant, implode(', ', \EnumType\XQSIGVariant::getValidValues())), __LINE__);
        }
        $this->qsigVariant = $qsigVariant;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \StructType\XVendorConfig $vendorConfig
     * @return \StructType\XH323Gateway
     */
    public function setVendorConfig(\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get pathReplacementSupport value
     * @return string|null
     */
    public function getPathReplacementSupport()
    {
        return $this->pathReplacementSupport;
    }
    /**
     * Set pathReplacementSupport value
     * @param string $pathReplacementSupport
     * @return \StructType\XH323Gateway
     */
    public function setPathReplacementSupport($pathReplacementSupport = false)
    {
        // validation for constraint: pattern
        if (is_scalar($pathReplacementSupport) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pathReplacementSupport, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pathReplacementSupport) && !is_string($pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pathReplacementSupport)), __LINE__);
        }
        $this->pathReplacementSupport = $pathReplacementSupport;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \StructType\XH323Gateway
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \StructType\XH323Gateway
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \StructType\XH323Gateway
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = true)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\XH323Gateway
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $geoLocationFilterName
     * @return \StructType\XH323Gateway
     */
    public function setGeoLocationFilterName(\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCdpnTransformationCssName(\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \StructType\XH323Gateway
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \StructType\XH323Gateway
     */
    public function setSrtpAllowed($srtpAllowed = false)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpAllowed)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get waitForFarEndH245TerminalSet value
     * @return string|null
     */
    public function getWaitForFarEndH245TerminalSet()
    {
        return $this->waitForFarEndH245TerminalSet;
    }
    /**
     * Set waitForFarEndH245TerminalSet value
     * @param string $waitForFarEndH245TerminalSet
     * @return \StructType\XH323Gateway
     */
    public function setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet = null)
    {
        // validation for constraint: pattern
        if (is_scalar($waitForFarEndH245TerminalSet) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $waitForFarEndH245TerminalSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($waitForFarEndH245TerminalSet, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($waitForFarEndH245TerminalSet) && !is_string($waitForFarEndH245TerminalSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($waitForFarEndH245TerminalSet)), __LINE__);
        }
        $this->waitForFarEndH245TerminalSet = $waitForFarEndH245TerminalSet;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \StructType\XH323Gateway
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mtpRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mtpRequired)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \StructType\XH323Gateway
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 50) || (is_array($callerIdDn) && count($callerIdDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get enableInboundFaststart value
     * @return string|null
     */
    public function getEnableInboundFaststart()
    {
        return $this->enableInboundFaststart;
    }
    /**
     * Set enableInboundFaststart value
     * @param string $enableInboundFaststart
     * @return \StructType\XH323Gateway
     */
    public function setEnableInboundFaststart($enableInboundFaststart = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableInboundFaststart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableInboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableInboundFaststart, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableInboundFaststart) && !is_string($enableInboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableInboundFaststart)), __LINE__);
        }
        $this->enableInboundFaststart = $enableInboundFaststart;
        return $this;
    }
    /**
     * Get enableOutboundFaststart value
     * @return string|null
     */
    public function getEnableOutboundFaststart()
    {
        return $this->enableOutboundFaststart;
    }
    /**
     * Set enableOutboundFaststart value
     * @param string $enableOutboundFaststart
     * @return \StructType\XH323Gateway
     */
    public function setEnableOutboundFaststart($enableOutboundFaststart = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableOutboundFaststart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableOutboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableOutboundFaststart, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableOutboundFaststart) && !is_string($enableOutboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableOutboundFaststart)), __LINE__);
        }
        $this->enableOutboundFaststart = $enableOutboundFaststart;
        return $this;
    }
    /**
     * Get codecForOutboundFaststart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodecForOutboundFaststart()
    {
        return isset($this->codecForOutboundFaststart) ? $this->codecForOutboundFaststart : null;
    }
    /**
     * Set codecForOutboundFaststart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XMediaPayload::valueIsValid()
     * @uses \EnumType\XMediaPayload::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codecForOutboundFaststart
     * @return \StructType\XH323Gateway
     */
    public function setCodecForOutboundFaststart($codecForOutboundFaststart = 'G711 u-law 64K')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMediaPayload::valueIsValid($codecForOutboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $codecForOutboundFaststart, implode(', ', \EnumType\XMediaPayload::getValidValues())), __LINE__);
        }
        if (is_null($codecForOutboundFaststart) || (is_array($codecForOutboundFaststart) && empty($codecForOutboundFaststart))) {
            unset($this->codecForOutboundFaststart);
        } else {
            $this->codecForOutboundFaststart = $codecForOutboundFaststart;
        }
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \StructType\XH323Gateway
     */
    public function setTransmitUtf8($transmitUtf8 = false)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get allowH235PassThrough value
     * @return string|null
     */
    public function getAllowH235PassThrough()
    {
        return $this->allowH235PassThrough;
    }
    /**
     * Set allowH235PassThrough value
     * @param string $allowH235PassThrough
     * @return \StructType\XH323Gateway
     */
    public function setAllowH235PassThrough($allowH235PassThrough = false)
    {
        // validation for constraint: pattern
        if (is_scalar($allowH235PassThrough) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowH235PassThrough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowH235PassThrough, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowH235PassThrough) && !is_string($allowH235PassThrough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowH235PassThrough)), __LINE__);
        }
        $this->allowH235PassThrough = $allowH235PassThrough;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \StructType\SigDigits $sigDigits
     * @return \StructType\XH323Gateway
     */
    public function setSigDigits(\StructType\SigDigits $sigDigits = '0')
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get prefixDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDn()
    {
        return isset($this->prefixDn) ? $this->prefixDn : null;
    }
    /**
     * Set prefixDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDn
     * @return \StructType\XH323Gateway
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDn) && strlen($prefixDn) > 50) || (is_array($prefixDn) && count($prefixDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($prefixDn) ? strlen($prefixDn) : count($prefixDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDn)), __LINE__);
        }
        if (is_null($prefixDn) || (is_array($prefixDn) && empty($prefixDn))) {
            unset($this->prefixDn);
        } else {
            $this->prefixDn = $prefixDn;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalPrefix value
     * @return string|null
     */
    public function getCallingPartyNationalPrefix()
    {
        return $this->callingPartyNationalPrefix;
    }
    /**
     * Set callingPartyNationalPrefix value
     * @param string $callingPartyNationalPrefix
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyNationalPrefix($callingPartyNationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyNationalPrefix) && strlen($callingPartyNationalPrefix) > 16) || (is_array($callingPartyNationalPrefix) && count($callingPartyNationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyNationalPrefix) ? strlen($callingPartyNationalPrefix) : count($callingPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyNationalPrefix) && !is_string($callingPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyNationalPrefix)), __LINE__);
        }
        $this->callingPartyNationalPrefix = $callingPartyNationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyInternationalPrefix value
     * @return string|null
     */
    public function getCallingPartyInternationalPrefix()
    {
        return $this->callingPartyInternationalPrefix;
    }
    /**
     * Set callingPartyInternationalPrefix value
     * @param string $callingPartyInternationalPrefix
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyInternationalPrefix($callingPartyInternationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyInternationalPrefix) && strlen($callingPartyInternationalPrefix) > 16) || (is_array($callingPartyInternationalPrefix) && count($callingPartyInternationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyInternationalPrefix) ? strlen($callingPartyInternationalPrefix) : count($callingPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyInternationalPrefix) && !is_string($callingPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyInternationalPrefix)), __LINE__);
        }
        $this->callingPartyInternationalPrefix = $callingPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyUnknownPrefix value
     * @return string|null
     */
    public function getCallingPartyUnknownPrefix()
    {
        return $this->callingPartyUnknownPrefix;
    }
    /**
     * Set callingPartyUnknownPrefix value
     * @param string $callingPartyUnknownPrefix
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyUnknownPrefix($callingPartyUnknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyUnknownPrefix) && strlen($callingPartyUnknownPrefix) > 16) || (is_array($callingPartyUnknownPrefix) && count($callingPartyUnknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyUnknownPrefix) ? strlen($callingPartyUnknownPrefix) : count($callingPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyUnknownPrefix) && !is_string($callingPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyUnknownPrefix)), __LINE__);
        }
        $this->callingPartyUnknownPrefix = $callingPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get callingPartySubscriberPrefix value
     * @return string|null
     */
    public function getCallingPartySubscriberPrefix()
    {
        return $this->callingPartySubscriberPrefix;
    }
    /**
     * Set callingPartySubscriberPrefix value
     * @param string $callingPartySubscriberPrefix
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartySubscriberPrefix($callingPartySubscriberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartySubscriberPrefix) && strlen($callingPartySubscriberPrefix) > 16) || (is_array($callingPartySubscriberPrefix) && count($callingPartySubscriberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartySubscriberPrefix) ? strlen($callingPartySubscriberPrefix) : count($callingPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartySubscriberPrefix) && !is_string($callingPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartySubscriberPrefix)), __LINE__);
        }
        $this->callingPartySubscriberPrefix = $callingPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get callingPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyNationalStripDigits()
    {
        return isset($this->callingPartyNationalStripDigits) ? $this->callingPartyNationalStripDigits : null;
    }
    /**
     * Set callingPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNationalStripDigits
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyNationalStripDigits($callingPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNationalStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyNationalStripDigits) || (is_array($callingPartyNationalStripDigits) && empty($callingPartyNationalStripDigits))) {
            unset($this->callingPartyNationalStripDigits);
        } else {
            $this->callingPartyNationalStripDigits = $callingPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyInternationalStripDigits()
    {
        return isset($this->callingPartyInternationalStripDigits) ? $this->callingPartyInternationalStripDigits : null;
    }
    /**
     * Set callingPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyInternationalStripDigits
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyInternationalStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyInternationalStripDigits) || (is_array($callingPartyInternationalStripDigits) && empty($callingPartyInternationalStripDigits))) {
            unset($this->callingPartyInternationalStripDigits);
        } else {
            $this->callingPartyInternationalStripDigits = $callingPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyUnknownStripDigits()
    {
        return isset($this->callingPartyUnknownStripDigits) ? $this->callingPartyUnknownStripDigits : null;
    }
    /**
     * Set callingPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyUnknownStripDigits
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyUnknownStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyUnknownStripDigits) || (is_array($callingPartyUnknownStripDigits) && empty($callingPartyUnknownStripDigits))) {
            unset($this->callingPartyUnknownStripDigits);
        } else {
            $this->callingPartyUnknownStripDigits = $callingPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartySubscriberStripDigits()
    {
        return isset($this->callingPartySubscriberStripDigits) ? $this->callingPartySubscriberStripDigits : null;
    }
    /**
     * Set callingPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySubscriberStripDigits
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySubscriberStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartySubscriberStripDigits) || (is_array($callingPartySubscriberStripDigits) && empty($callingPartySubscriberStripDigits))) {
            unset($this->callingPartySubscriberStripDigits);
        } else {
            $this->callingPartySubscriberStripDigits = $callingPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyNationalTransformationCssName()
    {
        return isset($this->callingPartyNationalTransformationCssName) ? $this->callingPartyNationalTransformationCssName : null;
    }
    /**
     * Set callingPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyNationalTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyNationalTransformationCssName(\StructType\XFkType $callingPartyNationalTransformationCssName = null)
    {
        if (is_null($callingPartyNationalTransformationCssName) || (is_array($callingPartyNationalTransformationCssName) && empty($callingPartyNationalTransformationCssName))) {
            unset($this->callingPartyNationalTransformationCssName);
        } else {
            $this->callingPartyNationalTransformationCssName = $callingPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyInternationalTransformationCssName()
    {
        return isset($this->callingPartyInternationalTransformationCssName) ? $this->callingPartyInternationalTransformationCssName : null;
    }
    /**
     * Set callingPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyInternationalTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyInternationalTransformationCssName(\StructType\XFkType $callingPartyInternationalTransformationCssName = null)
    {
        if (is_null($callingPartyInternationalTransformationCssName) || (is_array($callingPartyInternationalTransformationCssName) && empty($callingPartyInternationalTransformationCssName))) {
            unset($this->callingPartyInternationalTransformationCssName);
        } else {
            $this->callingPartyInternationalTransformationCssName = $callingPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return isset($this->callingPartyUnknownTransformationCssName) ? $this->callingPartyUnknownTransformationCssName : null;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartyUnknownTransformationCssName(\StructType\XFkType $callingPartyUnknownTransformationCssName = null)
    {
        if (is_null($callingPartyUnknownTransformationCssName) || (is_array($callingPartyUnknownTransformationCssName) && empty($callingPartyUnknownTransformationCssName))) {
            unset($this->callingPartyUnknownTransformationCssName);
        } else {
            $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartySubscriberTransformationCssName()
    {
        return isset($this->callingPartySubscriberTransformationCssName) ? $this->callingPartySubscriberTransformationCssName : null;
    }
    /**
     * Set callingPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartySubscriberTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCallingPartySubscriberTransformationCssName(\StructType\XFkType $callingPartySubscriberTransformationCssName = null)
    {
        if (is_null($callingPartySubscriberTransformationCssName) || (is_array($callingPartySubscriberTransformationCssName) && empty($callingPartySubscriberTransformationCssName))) {
            unset($this->callingPartySubscriberTransformationCssName);
        } else {
            $this->callingPartySubscriberTransformationCssName = $callingPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyNationalPrefix) && strlen($calledPartyNationalPrefix) > 16) || (is_array($calledPartyNationalPrefix) && count($calledPartyNationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyNationalPrefix) ? strlen($calledPartyNationalPrefix) : count($calledPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyNationalPrefix) && !is_string($calledPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyNationalPrefix)), __LINE__);
        }
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyInternationalPrefix) && strlen($calledPartyInternationalPrefix) > 16) || (is_array($calledPartyInternationalPrefix) && count($calledPartyInternationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyInternationalPrefix) ? strlen($calledPartyInternationalPrefix) : count($calledPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyInternationalPrefix) && !is_string($calledPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyInternationalPrefix)), __LINE__);
        }
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyUnknownPrefix) && strlen($calledPartyUnknownPrefix) > 16) || (is_array($calledPartyUnknownPrefix) && count($calledPartyUnknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyUnknownPrefix) ? strlen($calledPartyUnknownPrefix) : count($calledPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyUnknownPrefix) && !is_string($calledPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyUnknownPrefix)), __LINE__);
        }
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartySubscriberPrefix) && strlen($calledPartySubscriberPrefix) > 16) || (is_array($calledPartySubscriberPrefix) && count($calledPartySubscriberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartySubscriberPrefix) ? strlen($calledPartySubscriberPrefix) : count($calledPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartySubscriberPrefix) && !is_string($calledPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartySubscriberPrefix)), __LINE__);
        }
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return isset($this->calledPartyNationalStripDigits) ? $this->calledPartyNationalStripDigits : null;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNationalStripDigits
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNationalStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyNationalStripDigits) || (is_array($calledPartyNationalStripDigits) && empty($calledPartyNationalStripDigits))) {
            unset($this->calledPartyNationalStripDigits);
        } else {
            $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return isset($this->calledPartyInternationalStripDigits) ? $this->calledPartyInternationalStripDigits : null;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyInternationalStripDigits
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyInternationalStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyInternationalStripDigits) || (is_array($calledPartyInternationalStripDigits) && empty($calledPartyInternationalStripDigits))) {
            unset($this->calledPartyInternationalStripDigits);
        } else {
            $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return isset($this->calledPartyUnknownStripDigits) ? $this->calledPartyUnknownStripDigits : null;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyUnknownStripDigits
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyUnknownStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyUnknownStripDigits) || (is_array($calledPartyUnknownStripDigits) && empty($calledPartyUnknownStripDigits))) {
            unset($this->calledPartyUnknownStripDigits);
        } else {
            $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return isset($this->calledPartySubscriberStripDigits) ? $this->calledPartySubscriberStripDigits : null;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartySubscriberStripDigits
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartySubscriberStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartySubscriberStripDigits) || (is_array($calledPartySubscriberStripDigits) && empty($calledPartySubscriberStripDigits))) {
            unset($this->calledPartySubscriberStripDigits);
        } else {
            $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return isset($this->calledPartyNationalTransformationCssName) ? $this->calledPartyNationalTransformationCssName : null;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyNationalTransformationCssName(\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        if (is_null($calledPartyNationalTransformationCssName) || (is_array($calledPartyNationalTransformationCssName) && empty($calledPartyNationalTransformationCssName))) {
            unset($this->calledPartyNationalTransformationCssName);
        } else {
            $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return isset($this->calledPartyInternationalTransformationCssName) ? $this->calledPartyInternationalTransformationCssName : null;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyInternationalTransformationCssName(\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        if (is_null($calledPartyInternationalTransformationCssName) || (is_array($calledPartyInternationalTransformationCssName) && empty($calledPartyInternationalTransformationCssName))) {
            unset($this->calledPartyInternationalTransformationCssName);
        } else {
            $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return isset($this->calledPartyUnknownTransformationCssName) ? $this->calledPartyUnknownTransformationCssName : null;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartyUnknownTransformationCssName(\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        if (is_null($calledPartyUnknownTransformationCssName) || (is_array($calledPartyUnknownTransformationCssName) && empty($calledPartyUnknownTransformationCssName))) {
            unset($this->calledPartyUnknownTransformationCssName);
        } else {
            $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return isset($this->calledPartySubscriberTransformationCssName) ? $this->calledPartySubscriberTransformationCssName : null;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCalledPartySubscriberTransformationCssName(\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        if (is_null($calledPartySubscriberTransformationCssName) || (is_array($calledPartySubscriberTransformationCssName) && empty($calledPartySubscriberTransformationCssName))) {
            unset($this->calledPartySubscriberTransformationCssName);
        } else {
            $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \StructType\XH323Gateway
     */
    public function setPstnAccess($pstnAccess = true)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $imeE164TransformationName
     * @return \StructType\XH323Gateway
     */
    public function setImeE164TransformationName(\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Get displayIeDelivery value
     * @return string|null
     */
    public function getDisplayIeDelivery()
    {
        return $this->displayIeDelivery;
    }
    /**
     * Set displayIeDelivery value
     * @param string $displayIeDelivery
     * @return \StructType\XH323Gateway
     */
    public function setDisplayIeDelivery($displayIeDelivery = null)
    {
        // validation for constraint: pattern
        if (is_scalar($displayIeDelivery) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $displayIeDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($displayIeDelivery, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($displayIeDelivery) && !is_string($displayIeDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayIeDelivery)), __LINE__);
        }
        $this->displayIeDelivery = $displayIeDelivery;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \StructType\XH323Gateway
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectOutboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectOutboundNumberIe, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectOutboundNumberIe) && !is_string($redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectOutboundNumberIe)), __LINE__);
        }
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \StructType\XH323Gateway
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectInboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectInboundNumberIe, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectInboundNumberIe) && !is_string($redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectInboundNumberIe)), __LINE__);
        }
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssNatl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssNatl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssNatl) && !is_string($useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssNatl)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssIntl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssIntl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssIntl) && !is_string($useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssIntl)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssSubs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssSubs, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssSubs) && !is_string($useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssSubs)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssNatl()
    {
        return $this->useDevicePoolCalledCssNatl;
    }
    /**
     * Set useDevicePoolCalledCssNatl value
     * @param string $useDevicePoolCalledCssNatl
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCalledCssNatl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCalledCssNatl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssNatl) && !is_string($useDevicePoolCalledCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCalledCssNatl)), __LINE__);
        }
        $this->useDevicePoolCalledCssNatl = $useDevicePoolCalledCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssIntl()
    {
        return $this->useDevicePoolCalledCssIntl;
    }
    /**
     * Set useDevicePoolCalledCssIntl value
     * @param string $useDevicePoolCalledCssIntl
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCalledCssIntl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCalledCssIntl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssIntl) && !is_string($useDevicePoolCalledCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCalledCssIntl)), __LINE__);
        }
        $this->useDevicePoolCalledCssIntl = $useDevicePoolCalledCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssUnkn()
    {
        return $this->useDevicePoolCalledCssUnkn;
    }
    /**
     * Set useDevicePoolCalledCssUnkn value
     * @param string $useDevicePoolCalledCssUnkn
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCalledCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCalledCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssUnkn) && !is_string($useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCalledCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCalledCssUnkn = $useDevicePoolCalledCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssSubs()
    {
        return $this->useDevicePoolCalledCssSubs;
    }
    /**
     * Set useDevicePoolCalledCssSubs value
     * @param string $useDevicePoolCalledCssSubs
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCalledCssSubs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCalledCssSubs, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssSubs) && !is_string($useDevicePoolCalledCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCalledCssSubs)), __LINE__);
        }
        $this->useDevicePoolCalledCssSubs = $useDevicePoolCalledCssSubs;
        return $this;
    }
    /**
     * Get useDevicePoolCntdPnTransformationCss value
     * @return string|null
     */
    public function getUseDevicePoolCntdPnTransformationCss()
    {
        return $this->useDevicePoolCntdPnTransformationCss;
    }
    /**
     * Set useDevicePoolCntdPnTransformationCss value
     * @param string $useDevicePoolCntdPnTransformationCss
     * @return \StructType\XH323Gateway
     */
    public function setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCntdPnTransformationCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCntdPnTransformationCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCntdPnTransformationCss) && !is_string($useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCntdPnTransformationCss)), __LINE__);
        }
        $this->useDevicePoolCntdPnTransformationCss = $useDevicePoolCntdPnTransformationCss;
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return isset($this->cntdPnTransformationCssName) ? $this->cntdPnTransformationCssName : null;
    }
    /**
     * Set cntdPnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @return \StructType\XH323Gateway
     */
    public function setCntdPnTransformationCssName(\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        if (is_null($cntdPnTransformationCssName) || (is_array($cntdPnTransformationCssName) && empty($cntdPnTransformationCssName))) {
            unset($this->cntdPnTransformationCssName);
        } else {
            $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\XH323Gateway
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get redirectingPartyTransformationCSS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRedirectingPartyTransformationCSS()
    {
        return isset($this->redirectingPartyTransformationCSS) ? $this->redirectingPartyTransformationCSS : null;
    }
    /**
     * Set redirectingPartyTransformationCSS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $redirectingPartyTransformationCSS
     * @return \StructType\XH323Gateway
     */
    public function setRedirectingPartyTransformationCSS(\StructType\XFkType $redirectingPartyTransformationCSS = null)
    {
        if (is_null($redirectingPartyTransformationCSS) || (is_array($redirectingPartyTransformationCSS) && empty($redirectingPartyTransformationCSS))) {
            unset($this->redirectingPartyTransformationCSS);
        } else {
            $this->redirectingPartyTransformationCSS = $redirectingPartyTransformationCSS;
        }
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\XH323Gateway
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XH323Gateway
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
