<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XFeatureControlConfig StructType
 * @subpackage Structs
 */
class XFeatureControlConfig extends AbstractStructBase
{
    /**
     * The featureName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * @var string
     */
    public $featureName;
    /**
     * The overrideDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $overrideDefault;
    /**
     * The enableSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag will be taken to consideration only when 'overrideDefault' tag is set to True.This will be handled in the code.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableSetting;
    /**
     * Constructor method for XFeatureControlConfig
     * @uses XFeatureControlConfig::setFeatureName()
     * @uses XFeatureControlConfig::setOverrideDefault()
     * @uses XFeatureControlConfig::setEnableSetting()
     * @param string $featureName
     * @param string $overrideDefault
     * @param string $enableSetting
     */
    public function __construct($featureName = null, $overrideDefault = null, $enableSetting = null)
    {
        $this
            ->setFeatureName($featureName)
            ->setOverrideDefault($overrideDefault)
            ->setEnableSetting($enableSetting);
    }
    /**
     * Get featureName value
     * @return string
     */
    public function getFeatureName()
    {
        return $this->featureName;
    }
    /**
     * Set featureName value
     * @param string $featureName
     * @return \StructType\XFeatureControlConfig
     */
    public function setFeatureName($featureName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($featureName) && strlen($featureName) > 50) || (is_array($featureName) && count($featureName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($featureName) ? strlen($featureName) : count($featureName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($featureName) && !is_string($featureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($featureName)), __LINE__);
        }
        $this->featureName = $featureName;
        return $this;
    }
    /**
     * Get overrideDefault value
     * @return string|null
     */
    public function getOverrideDefault()
    {
        return $this->overrideDefault;
    }
    /**
     * Set overrideDefault value
     * @param string $overrideDefault
     * @return \StructType\XFeatureControlConfig
     */
    public function setOverrideDefault($overrideDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($overrideDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $overrideDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($overrideDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($overrideDefault) && !is_string($overrideDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overrideDefault)), __LINE__);
        }
        $this->overrideDefault = $overrideDefault;
        return $this;
    }
    /**
     * Get enableSetting value
     * @return string|null
     */
    public function getEnableSetting()
    {
        return $this->enableSetting;
    }
    /**
     * Set enableSetting value
     * @param string $enableSetting
     * @return \StructType\XFeatureControlConfig
     */
    public function setEnableSetting($enableSetting = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableSetting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableSetting, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableSetting) && !is_string($enableSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableSetting)), __LINE__);
        }
        $this->enableSetting = $enableSetting;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XFeatureControlConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
