<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XConferenceNow StructType
 * @subpackage Structs
 */
class XConferenceNow extends AbstractStructBase
{
    /**
     * The conferenceNowNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $conferenceNowNumber;
    /**
     * The maxWaitTimeForHost
     * Meta informations extracted from the WSDL
     * - default: 15
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $maxWaitTimeForHost;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The MohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MohAudioSourceId;
    /**
     * Constructor method for XConferenceNow
     * @uses XConferenceNow::setConferenceNowNumber()
     * @uses XConferenceNow::setMaxWaitTimeForHost()
     * @uses XConferenceNow::setRoutePartitionName()
     * @uses XConferenceNow::setDescription()
     * @uses XConferenceNow::setMohAudioSourceId()
     * @param string $conferenceNowNumber
     * @param string $maxWaitTimeForHost
     * @param \StructType\XFkType $routePartitionName
     * @param string $description
     * @param string $mohAudioSourceId
     */
    public function __construct($conferenceNowNumber = null, $maxWaitTimeForHost = '15', \StructType\XFkType $routePartitionName = null, $description = null, $mohAudioSourceId = null)
    {
        $this
            ->setConferenceNowNumber($conferenceNowNumber)
            ->setMaxWaitTimeForHost($maxWaitTimeForHost)
            ->setRoutePartitionName($routePartitionName)
            ->setDescription($description)
            ->setMohAudioSourceId($mohAudioSourceId);
    }
    /**
     * Get conferenceNowNumber value
     * @return string
     */
    public function getConferenceNowNumber()
    {
        return $this->conferenceNowNumber;
    }
    /**
     * Set conferenceNowNumber value
     * @param string $conferenceNowNumber
     * @return \StructType\XConferenceNow
     */
    public function setConferenceNowNumber($conferenceNowNumber = null)
    {
        // validation for constraint: string
        if (!is_null($conferenceNowNumber) && !is_string($conferenceNowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conferenceNowNumber)), __LINE__);
        }
        $this->conferenceNowNumber = $conferenceNowNumber;
        return $this;
    }
    /**
     * Get maxWaitTimeForHost value
     * @return string
     */
    public function getMaxWaitTimeForHost()
    {
        return $this->maxWaitTimeForHost;
    }
    /**
     * Set maxWaitTimeForHost value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxWaitTimeForHost
     * @return \StructType\XConferenceNow
     */
    public function setMaxWaitTimeForHost($maxWaitTimeForHost = '15')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxWaitTimeForHost)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxWaitTimeForHost, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxWaitTimeForHost = $maxWaitTimeForHost;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\XConferenceNow
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XConferenceNow
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get MohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMohAudioSourceId()
    {
        return isset($this->MohAudioSourceId) ? $this->MohAudioSourceId : null;
    }
    /**
     * Set MohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mohAudioSourceId
     * @return \StructType\XConferenceNow
     */
    public function setMohAudioSourceId($mohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($mohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($mohAudioSourceId) || (is_array($mohAudioSourceId) && empty($mohAudioSourceId))) {
            unset($this->MohAudioSourceId);
        } else {
            $this->MohAudioSourceId = $mohAudioSourceId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XConferenceNow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
