<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallPickupGroup StructType
 * @subpackage Structs
 */
class XCallPickupGroup extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The pickupNotification
     * Meta informations extracted from the WSDL
     * - default: No Alert
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pickupNotification;
    /**
     * The pickupNotificationTimer
     * Meta informations extracted from the WSDL
     * - default: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pickupNotificationTimer;
    /**
     * The callInfoForPickupNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CallInfoForPickupNotification
     */
    public $callInfoForPickupNotification;
    /**
     * Constructor method for XCallPickupGroup
     * @uses XCallPickupGroup::setPattern()
     * @uses XCallPickupGroup::setName()
     * @uses XCallPickupGroup::setDescription()
     * @uses XCallPickupGroup::setRoutePartitionName()
     * @uses XCallPickupGroup::setMembers()
     * @uses XCallPickupGroup::setPickupNotification()
     * @uses XCallPickupGroup::setPickupNotificationTimer()
     * @uses XCallPickupGroup::setCallInfoForPickupNotification()
     * @param string $pattern
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $routePartitionName
     * @param \StructType\Members $members
     * @param string $pickupNotification
     * @param string $pickupNotificationTimer
     * @param \StructType\CallInfoForPickupNotification $callInfoForPickupNotification
     */
    public function __construct($pattern = null, $name = null, $description = null, \StructType\XFkType $routePartitionName = null, \StructType\Members $members = null, $pickupNotification = 'No Alert', $pickupNotificationTimer = '6', \StructType\CallInfoForPickupNotification $callInfoForPickupNotification = null)
    {
        $this
            ->setPattern($pattern)
            ->setName($name)
            ->setDescription($description)
            ->setRoutePartitionName($routePartitionName)
            ->setMembers($members)
            ->setPickupNotification($pickupNotification)
            ->setPickupNotificationTimer($pickupNotificationTimer)
            ->setCallInfoForPickupNotification($callInfoForPickupNotification);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\XCallPickupGroup
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XCallPickupGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XCallPickupGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\XCallPickupGroup
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\XCallPickupGroup
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get pickupNotification value
     * @return string|null
     */
    public function getPickupNotification()
    {
        return $this->pickupNotification;
    }
    /**
     * Set pickupNotification value
     * @uses \EnumType\XPickupNotification::valueIsValid()
     * @uses \EnumType\XPickupNotification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotification
     * @return \StructType\XCallPickupGroup
     */
    public function setPickupNotification($pickupNotification = 'No Alert')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPickupNotification::valueIsValid($pickupNotification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pickupNotification, implode(', ', \EnumType\XPickupNotification::getValidValues())), __LINE__);
        }
        $this->pickupNotification = $pickupNotification;
        return $this;
    }
    /**
     * Get pickupNotificationTimer value
     * @return string|null
     */
    public function getPickupNotificationTimer()
    {
        return $this->pickupNotificationTimer;
    }
    /**
     * Set pickupNotificationTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotificationTimer
     * @return \StructType\XCallPickupGroup
     */
    public function setPickupNotificationTimer($pickupNotificationTimer = '6')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($pickupNotificationTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pickupNotificationTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pickupNotificationTimer = $pickupNotificationTimer;
        return $this;
    }
    /**
     * Get callInfoForPickupNotification value
     * @return \StructType\CallInfoForPickupNotification|null
     */
    public function getCallInfoForPickupNotification()
    {
        return $this->callInfoForPickupNotification;
    }
    /**
     * Set callInfoForPickupNotification value
     * @param \StructType\CallInfoForPickupNotification $callInfoForPickupNotification
     * @return \StructType\XCallPickupGroup
     */
    public function setCallInfoForPickupNotification(\StructType\CallInfoForPickupNotification $callInfoForPickupNotification = null)
    {
        $this->callInfoForPickupNotification = $callInfoForPickupNotification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XCallPickupGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
