<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallManagerMember StructType
 * @subpackage Structs
 */
class XCallManagerMember extends AbstractStructBase
{
    /**
     * The callManagerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $callManagerName;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $priority;
    /**
     * Constructor method for XCallManagerMember
     * @uses XCallManagerMember::setCallManagerName()
     * @uses XCallManagerMember::setPriority()
     * @param \StructType\XFkType $callManagerName
     * @param string $priority
     */
    public function __construct(\StructType\XFkType $callManagerName = null, $priority = null)
    {
        $this
            ->setCallManagerName($callManagerName)
            ->setPriority($priority);
    }
    /**
     * Get callManagerName value
     * @return \StructType\XFkType
     */
    public function getCallManagerName()
    {
        return $this->callManagerName;
    }
    /**
     * Set callManagerName value
     * @param \StructType\XFkType $callManagerName
     * @return \StructType\XCallManagerMember
     */
    public function setCallManagerName(\StructType\XFkType $callManagerName = null)
    {
        $this->callManagerName = $callManagerName;
        return $this;
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\XCallManagerMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XCallManagerMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
