<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XBlockedLearnedPatterns StructType
 * @subpackage Structs
 */
class XBlockedLearnedPatterns extends AbstractStructBase
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $prefix;
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $clusterId;
    /**
     * The patternType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $patternType;
    /**
     * Constructor method for XBlockedLearnedPatterns
     * @uses XBlockedLearnedPatterns::setDescription()
     * @uses XBlockedLearnedPatterns::setPattern()
     * @uses XBlockedLearnedPatterns::setPrefix()
     * @uses XBlockedLearnedPatterns::setClusterId()
     * @uses XBlockedLearnedPatterns::setPatternType()
     * @param string $description
     * @param string $pattern
     * @param string $prefix
     * @param string $clusterId
     * @param string $patternType
     */
    public function __construct($description = null, $pattern = null, $prefix = null, $clusterId = null, $patternType = null)
    {
        $this
            ->setDescription($description)
            ->setPattern($pattern)
            ->setPrefix($prefix)
            ->setClusterId($clusterId)
            ->setPatternType($patternType);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XBlockedLearnedPatterns
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\XBlockedLearnedPatterns
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \StructType\XBlockedLearnedPatterns
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \StructType\XBlockedLearnedPatterns
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get patternType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPatternType()
    {
        return isset($this->patternType) ? $this->patternType : null;
    }
    /**
     * Set patternType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XGlobalNumber::valueIsValid()
     * @uses \EnumType\XGlobalNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternType
     * @return \StructType\XBlockedLearnedPatterns
     */
    public function setPatternType($patternType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XGlobalNumber::valueIsValid($patternType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternType, implode(', ', \EnumType\XGlobalNumber::getValidValues())), __LINE__);
        }
        if (is_null($patternType) || (is_array($patternType) && empty($patternType))) {
            unset($this->patternType);
        } else {
            $this->patternType = $patternType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XBlockedLearnedPatterns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
