<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userGroup StructType
 * @subpackage Structs
 */
class UserGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name of User Group | Name of User Group | Name of User Group | Name of User Group | Name of User Group | Name of User Group
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $name;
    /**
     * The userRoles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UserRoles
     */
    public $userRoles;
    /**
     * Constructor method for userGroup
     * @uses UserGroup::setName()
     * @uses UserGroup::setUserRoles()
     * @param string $name
     * @param \StructType\UserRoles $userRoles
     */
    public function __construct($name = null, \StructType\UserRoles $userRoles = null)
    {
        $this
            ->setName($name)
            ->setUserRoles($userRoles);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UserGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 100) || (is_array($name) && count($name) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get userRoles value
     * @return \StructType\UserRoles|null
     */
    public function getUserRoles()
    {
        return $this->userRoles;
    }
    /**
     * Set userRoles value
     * @param \StructType\UserRoles $userRoles
     * @return \StructType\UserGroup
     */
    public function setUserRoles(\StructType\UserRoles $userRoles = null)
    {
        $this->userRoles = $userRoles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
