<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateProcessNodeServiceReq StructType
 * @subpackage Structs
 */
class UpdateProcessNodeServiceReq extends APIRequest
{
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $processNodeName;
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $service;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The traceLevel
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $traceLevel;
    /**
     * The userCategories
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userCategories;
    /**
     * The enable
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enable;
    /**
     * The numFiles
     * Meta informations extracted from the WSDL
     * - default: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numFiles;
    /**
     * The maxFileSize
     * Meta informations extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxFileSize;
    /**
     * Constructor method for UpdateProcessNodeServiceReq
     * @uses UpdateProcessNodeServiceReq::setProcessNodeName()
     * @uses UpdateProcessNodeServiceReq::setService()
     * @uses UpdateProcessNodeServiceReq::setUuid()
     * @uses UpdateProcessNodeServiceReq::setTraceLevel()
     * @uses UpdateProcessNodeServiceReq::setUserCategories()
     * @uses UpdateProcessNodeServiceReq::setEnable()
     * @uses UpdateProcessNodeServiceReq::setNumFiles()
     * @uses UpdateProcessNodeServiceReq::setMaxFileSize()
     * @param \StructType\XFkType $processNodeName
     * @param string $service
     * @param string $uuid
     * @param string $traceLevel
     * @param string $userCategories
     * @param string $enable
     * @param string $numFiles
     * @param string $maxFileSize
     */
    public function __construct(\StructType\XFkType $processNodeName = null, $service = null, $uuid = null, $traceLevel = '0', $userCategories = '0', $enable = false, $numFiles = '250', $maxFileSize = '1')
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setService($service)
            ->setUuid($uuid)
            ->setTraceLevel($traceLevel)
            ->setUserCategories($userCategories)
            ->setEnable($enable)
            ->setNumFiles($numFiles)
            ->setMaxFileSize($maxFileSize);
    }
    /**
     * Get processNodeName value
     * @return \StructType\XFkType
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \StructType\XFkType $processNodeName
     * @return \StructType\UpdateProcessNodeServiceReq
     */
    public function setProcessNodeName(\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses \EnumType\XService::valueIsValid()
     * @uses \EnumType\XService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return \StructType\UpdateProcessNodeServiceReq
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XService::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $service, implode(', ', \EnumType\XService::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateProcessNodeServiceReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get traceLevel value
     * @return string|null
     */
    public function getTraceLevel()
    {
        return $this->traceLevel;
    }
    /**
     * Set traceLevel value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traceLevel
     * @return \StructType\UpdateProcessNodeServiceReq
     */
    public function setTraceLevel($traceLevel = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($traceLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $traceLevel, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->traceLevel = $traceLevel;
        return $this;
    }
    /**
     * Get userCategories value
     * @return string|null
     */
    public function getUserCategories()
    {
        return $this->userCategories;
    }
    /**
     * Set userCategories value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userCategories
     * @return \StructType\UpdateProcessNodeServiceReq
     */
    public function setUserCategories($userCategories = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($userCategories)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userCategories, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->userCategories = $userCategories;
        return $this;
    }
    /**
     * Get enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->enable;
    }
    /**
     * Set enable value
     * @param string $enable
     * @return \StructType\UpdateProcessNodeServiceReq
     */
    public function setEnable($enable = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enable)), __LINE__);
        }
        $this->enable = $enable;
        return $this;
    }
    /**
     * Get numFiles value
     * @return string|null
     */
    public function getNumFiles()
    {
        return $this->numFiles;
    }
    /**
     * Set numFiles value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numFiles
     * @return \StructType\UpdateProcessNodeServiceReq
     */
    public function setNumFiles($numFiles = '250')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($numFiles)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numFiles, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numFiles = $numFiles;
        return $this;
    }
    /**
     * Get maxFileSize value
     * @return string|null
     */
    public function getMaxFileSize()
    {
        return $this->maxFileSize;
    }
    /**
     * Set maxFileSize value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxFileSize
     * @return \StructType\UpdateProcessNodeServiceReq
     */
    public function setMaxFileSize($maxFileSize = '1')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxFileSize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxFileSize, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxFileSize = $maxFileSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateProcessNodeServiceReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
