<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateNetworkAccessProfileReq StructType
 * @subpackage Structs
 */
class UpdateNetworkAccessProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The vpnRequired
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $vpnRequired;
    /**
     * The proxySettings
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxySettings;
    /**
     * The proxyHostname
     * Meta informations extracted from the WSDL
     * - documentation: This tag corresponds to Proxy Auto-Config (PAC) Location when proxy setting is set to Auto
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyHostname;
    /**
     * The proxyPort
     * Meta informations extracted from the WSDL
     * - default: 8080
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyPort;
    /**
     * The proxyRequiresAuthentication
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $proxyRequiresAuthentication;
    /**
     * The provideSharedCredentials
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: This tag is used for validation and does not correspond to any field in database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideSharedCredentials;
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * Constructor method for UpdateNetworkAccessProfileReq
     * @uses UpdateNetworkAccessProfileReq::setNewName()
     * @uses UpdateNetworkAccessProfileReq::setDescription()
     * @uses UpdateNetworkAccessProfileReq::setVpnRequired()
     * @uses UpdateNetworkAccessProfileReq::setProxySettings()
     * @uses UpdateNetworkAccessProfileReq::setProxyHostname()
     * @uses UpdateNetworkAccessProfileReq::setProxyPort()
     * @uses UpdateNetworkAccessProfileReq::setProxyRequiresAuthentication()
     * @uses UpdateNetworkAccessProfileReq::setProvideSharedCredentials()
     * @uses UpdateNetworkAccessProfileReq::setUsername()
     * @uses UpdateNetworkAccessProfileReq::setPassword()
     * @param string $newName
     * @param string $description
     * @param string $vpnRequired
     * @param string $proxySettings
     * @param string $proxyHostname
     * @param string $proxyPort
     * @param string $proxyRequiresAuthentication
     * @param string $provideSharedCredentials
     * @param string $username
     * @param string $password
     */
    public function __construct($newName = null, $description = null, $vpnRequired = 'Default', $proxySettings = 'None', $proxyHostname = null, $proxyPort = '8080', $proxyRequiresAuthentication = false, $provideSharedCredentials = false, $username = null, $password = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setVpnRequired($vpnRequired)
            ->setProxySettings($proxySettings)
            ->setProxyHostname($proxyHostname)
            ->setProxyPort($proxyPort)
            ->setProxyRequiresAuthentication($proxyRequiresAuthentication)
            ->setProvideSharedCredentials($provideSharedCredentials)
            ->setUsername($username)
            ->setPassword($password);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 128) || (is_array($newName) && count($newName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get vpnRequired value
     * @return string|null
     */
    public function getVpnRequired()
    {
        return $this->vpnRequired;
    }
    /**
     * Set vpnRequired value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vpnRequired
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setVpnRequired($vpnRequired = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($vpnRequired)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vpnRequired, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->vpnRequired = $vpnRequired;
        return $this;
    }
    /**
     * Get proxySettings value
     * @return string|null
     */
    public function getProxySettings()
    {
        return $this->proxySettings;
    }
    /**
     * Set proxySettings value
     * @uses \EnumType\XHTTPProxy::valueIsValid()
     * @uses \EnumType\XHTTPProxy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $proxySettings
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxySettings($proxySettings = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHTTPProxy::valueIsValid($proxySettings)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $proxySettings, implode(', ', \EnumType\XHTTPProxy::getValidValues())), __LINE__);
        }
        $this->proxySettings = $proxySettings;
        return $this;
    }
    /**
     * Get proxyHostname value
     * @return string|null
     */
    public function getProxyHostname()
    {
        return $this->proxyHostname;
    }
    /**
     * Set proxyHostname value
     * @param string $proxyHostname
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxyHostname($proxyHostname = null)
    {
        // validation for constraint: string
        if (!is_null($proxyHostname) && !is_string($proxyHostname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyHostname)), __LINE__);
        }
        $this->proxyHostname = $proxyHostname;
        return $this;
    }
    /**
     * Get proxyPort value
     * @return string|null
     */
    public function getProxyPort()
    {
        return $this->proxyPort;
    }
    /**
     * Set proxyPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $proxyPort
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxyPort($proxyPort = '8080')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($proxyPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $proxyPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->proxyPort = $proxyPort;
        return $this;
    }
    /**
     * Get proxyRequiresAuthentication value
     * @return string|null
     */
    public function getProxyRequiresAuthentication()
    {
        return $this->proxyRequiresAuthentication;
    }
    /**
     * Set proxyRequiresAuthentication value
     * @param string $proxyRequiresAuthentication
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxyRequiresAuthentication($proxyRequiresAuthentication = false)
    {
        // validation for constraint: pattern
        if (is_scalar($proxyRequiresAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $proxyRequiresAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($proxyRequiresAuthentication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($proxyRequiresAuthentication) && !is_string($proxyRequiresAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyRequiresAuthentication)), __LINE__);
        }
        $this->proxyRequiresAuthentication = $proxyRequiresAuthentication;
        return $this;
    }
    /**
     * Get provideSharedCredentials value
     * @return string|null
     */
    public function getProvideSharedCredentials()
    {
        return $this->provideSharedCredentials;
    }
    /**
     * Set provideSharedCredentials value
     * @param string $provideSharedCredentials
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setProvideSharedCredentials($provideSharedCredentials = false)
    {
        // validation for constraint: pattern
        if (is_scalar($provideSharedCredentials) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideSharedCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($provideSharedCredentials, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($provideSharedCredentials) && !is_string($provideSharedCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provideSharedCredentials)), __LINE__);
        }
        $this->provideSharedCredentials = $provideSharedCredentials;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateNetworkAccessProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
