<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLineGroupReq StructType
 * @subpackage Structs
 */
class UpdateLineGroupReq extends NameAndGUIDRequest
{
    /**
     * The distributionAlgorithm
     * Meta informations extracted from the WSDL
     * - default: Longest Idle Time
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The rnaReversionTimeOut
     * Meta informations extracted from the WSDL
     * - default: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rnaReversionTimeOut;
    /**
     * The huntAlgorithmNoAnswer
     * Meta informations extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmNoAnswer;
    /**
     * The huntAlgorithmBusy
     * Meta informations extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmBusy;
    /**
     * The huntAlgorithmNotAvailable
     * Meta informations extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmNotAvailable;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The autoLogOffHunt
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $autoLogOffHunt;
    /**
     * Constructor method for UpdateLineGroupReq
     * @uses UpdateLineGroupReq::setDistributionAlgorithm()
     * @uses UpdateLineGroupReq::setRnaReversionTimeOut()
     * @uses UpdateLineGroupReq::setHuntAlgorithmNoAnswer()
     * @uses UpdateLineGroupReq::setHuntAlgorithmBusy()
     * @uses UpdateLineGroupReq::setHuntAlgorithmNotAvailable()
     * @uses UpdateLineGroupReq::setRemoveMembers()
     * @uses UpdateLineGroupReq::setAddMembers()
     * @uses UpdateLineGroupReq::setMembers()
     * @uses UpdateLineGroupReq::setNewName()
     * @uses UpdateLineGroupReq::setAutoLogOffHunt()
     * @param string $distributionAlgorithm
     * @param string $rnaReversionTimeOut
     * @param string $huntAlgorithmNoAnswer
     * @param string $huntAlgorithmBusy
     * @param string $huntAlgorithmNotAvailable
     * @param \StructType\RemoveMembers $removeMembers
     * @param \StructType\AddMembers $addMembers
     * @param \StructType\Members $members
     * @param string $newName
     * @param string $autoLogOffHunt
     */
    public function __construct($distributionAlgorithm = 'Longest Idle Time', $rnaReversionTimeOut = '10', $huntAlgorithmNoAnswer = 'Try next member; then, try next group in Hunt List', $huntAlgorithmBusy = 'Try next member; then, try next group in Hunt List', $huntAlgorithmNotAvailable = 'Try next member; then, try next group in Hunt List', \StructType\RemoveMembers $removeMembers = null, \StructType\AddMembers $addMembers = null, \StructType\Members $members = null, $newName = null, $autoLogOffHunt = false)
    {
        $this
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setRnaReversionTimeOut($rnaReversionTimeOut)
            ->setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer)
            ->setHuntAlgorithmBusy($huntAlgorithmBusy)
            ->setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setNewName($newName)
            ->setAutoLogOffHunt($autoLogOffHunt);
    }
    /**
     * Get distributionAlgorithm value
     * @return string|null
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses \EnumType\XDistributeAlgorithm::valueIsValid()
     * @uses \EnumType\XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return \StructType\UpdateLineGroupReq
     */
    public function setDistributionAlgorithm($distributionAlgorithm = 'Longest Idle Time')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distributionAlgorithm, implode(', ', \EnumType\XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get rnaReversionTimeOut value
     * @return string|null
     */
    public function getRnaReversionTimeOut()
    {
        return $this->rnaReversionTimeOut;
    }
    /**
     * Set rnaReversionTimeOut value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rnaReversionTimeOut
     * @return \StructType\UpdateLineGroupReq
     */
    public function setRnaReversionTimeOut($rnaReversionTimeOut = '10')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($rnaReversionTimeOut)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rnaReversionTimeOut, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rnaReversionTimeOut = $rnaReversionTimeOut;
        return $this;
    }
    /**
     * Get huntAlgorithmNoAnswer value
     * @return string|null
     */
    public function getHuntAlgorithmNoAnswer()
    {
        return $this->huntAlgorithmNoAnswer;
    }
    /**
     * Set huntAlgorithmNoAnswer value
     * @uses \EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNoAnswer
     * @return \StructType\UpdateLineGroupReq
     */
    public function setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmNoAnswer, implode(', ', \EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNoAnswer = $huntAlgorithmNoAnswer;
        return $this;
    }
    /**
     * Get huntAlgorithmBusy value
     * @return string|null
     */
    public function getHuntAlgorithmBusy()
    {
        return $this->huntAlgorithmBusy;
    }
    /**
     * Set huntAlgorithmBusy value
     * @uses \EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmBusy
     * @return \StructType\UpdateLineGroupReq
     */
    public function setHuntAlgorithmBusy($huntAlgorithmBusy = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmBusy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmBusy, implode(', ', \EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmBusy = $huntAlgorithmBusy;
        return $this;
    }
    /**
     * Get huntAlgorithmNotAvailable value
     * @return string|null
     */
    public function getHuntAlgorithmNotAvailable()
    {
        return $this->huntAlgorithmNotAvailable;
    }
    /**
     * Set huntAlgorithmNotAvailable value
     * @uses \EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNotAvailable
     * @return \StructType\UpdateLineGroupReq
     */
    public function setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNotAvailable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmNotAvailable, implode(', ', \EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNotAvailable = $huntAlgorithmNotAvailable;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \StructType\RemoveMembers $removeMembers
     * @return \StructType\UpdateLineGroupReq
     */
    public function setRemoveMembers(\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \StructType\AddMembers $addMembers
     * @return \StructType\UpdateLineGroupReq
     */
    public function setAddMembers(\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\UpdateLineGroupReq
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateLineGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get autoLogOffHunt value
     * @return string|null
     */
    public function getAutoLogOffHunt()
    {
        return $this->autoLogOffHunt;
    }
    /**
     * Set autoLogOffHunt value
     * @param string $autoLogOffHunt
     * @return \StructType\UpdateLineGroupReq
     */
    public function setAutoLogOffHunt($autoLogOffHunt = false)
    {
        // validation for constraint: pattern
        if (is_scalar($autoLogOffHunt) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $autoLogOffHunt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($autoLogOffHunt, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($autoLogOffHunt) && !is_string($autoLogOffHunt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoLogOffHunt)), __LINE__);
        }
        $this->autoLogOffHunt = $autoLogOffHunt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateLineGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
