<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLdapAuthenticationReq StructType
 * @subpackage Structs
 */
class UpdateLdapAuthenticationReq extends AbstractStructBase
{
    /**
     * The authenticateEndUsers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $authenticateEndUsers;
    /**
     * The distinguishedName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $distinguishedName;
    /**
     * The ldapPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $userSearchBase;
    /**
     * The servers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Servers
     */
    public $servers;
    /**
     * Constructor method for UpdateLdapAuthenticationReq
     * @uses UpdateLdapAuthenticationReq::setAuthenticateEndUsers()
     * @uses UpdateLdapAuthenticationReq::setDistinguishedName()
     * @uses UpdateLdapAuthenticationReq::setLdapPassword()
     * @uses UpdateLdapAuthenticationReq::setUserSearchBase()
     * @uses UpdateLdapAuthenticationReq::setServers()
     * @param string $authenticateEndUsers
     * @param string $distinguishedName
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param \StructType\Servers $servers
     */
    public function __construct($authenticateEndUsers = null, $distinguishedName = null, $ldapPassword = null, $userSearchBase = null, \StructType\Servers $servers = null)
    {
        $this
            ->setAuthenticateEndUsers($authenticateEndUsers)
            ->setDistinguishedName($distinguishedName)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setServers($servers);
    }
    /**
     * Get authenticateEndUsers value
     * @return string|null
     */
    public function getAuthenticateEndUsers()
    {
        return $this->authenticateEndUsers;
    }
    /**
     * Set authenticateEndUsers value
     * @param string $authenticateEndUsers
     * @return \StructType\UpdateLdapAuthenticationReq
     */
    public function setAuthenticateEndUsers($authenticateEndUsers = null)
    {
        // validation for constraint: pattern
        if (is_scalar($authenticateEndUsers) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $authenticateEndUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($authenticateEndUsers, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authenticateEndUsers) && !is_string($authenticateEndUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticateEndUsers)), __LINE__);
        }
        $this->authenticateEndUsers = $authenticateEndUsers;
        return $this;
    }
    /**
     * Get distinguishedName value
     * @return string|null
     */
    public function getDistinguishedName()
    {
        return $this->distinguishedName;
    }
    /**
     * Set distinguishedName value
     * @param string $distinguishedName
     * @return \StructType\UpdateLdapAuthenticationReq
     */
    public function setDistinguishedName($distinguishedName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($distinguishedName) && strlen($distinguishedName) > 128) || (is_array($distinguishedName) && count($distinguishedName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($distinguishedName) ? strlen($distinguishedName) : count($distinguishedName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($distinguishedName) && !is_string($distinguishedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distinguishedName)), __LINE__);
        }
        $this->distinguishedName = $distinguishedName;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \StructType\UpdateLdapAuthenticationReq
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapPassword) && strlen($ldapPassword) > 128) || (is_array($ldapPassword) && count($ldapPassword) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapPassword) ? strlen($ldapPassword) : count($ldapPassword)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \StructType\UpdateLdapAuthenticationReq
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userSearchBase) && strlen($userSearchBase) > 255) || (is_array($userSearchBase) && count($userSearchBase) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($userSearchBase) ? strlen($userSearchBase) : count($userSearchBase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userSearchBase) && !is_string($userSearchBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userSearchBase)), __LINE__);
        }
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get servers value
     * @return \StructType\Servers|null
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \StructType\Servers $servers
     * @return \StructType\UpdateLdapAuthenticationReq
     */
    public function setServers(\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateLdapAuthenticationReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
