<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInterClusterDirectoryUriReq StructType
 * @subpackage Structs
 */
class UpdateInterClusterDirectoryUriReq extends APIRequest
{
    /**
     * The exchangeDirectoryUri
     * Meta informations extracted from the WSDL
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $exchangeDirectoryUri;
    /**
     * The routeString
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * @var string
     */
    public $routeString;
    /**
     * Constructor method for UpdateInterClusterDirectoryUriReq
     * @uses UpdateInterClusterDirectoryUriReq::setExchangeDirectoryUri()
     * @uses UpdateInterClusterDirectoryUriReq::setRouteString()
     * @param string $exchangeDirectoryUri
     * @param string $routeString
     */
    public function __construct($exchangeDirectoryUri = null, $routeString = null)
    {
        $this
            ->setExchangeDirectoryUri($exchangeDirectoryUri)
            ->setRouteString($routeString);
    }
    /**
     * Get exchangeDirectoryUri value
     * @return string|null
     */
    public function getExchangeDirectoryUri()
    {
        return $this->exchangeDirectoryUri;
    }
    /**
     * Set exchangeDirectoryUri value
     * @param string $exchangeDirectoryUri
     * @return \StructType\UpdateInterClusterDirectoryUriReq
     */
    public function setExchangeDirectoryUri($exchangeDirectoryUri = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exchangeDirectoryUri) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $exchangeDirectoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($exchangeDirectoryUri, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exchangeDirectoryUri) && !is_string($exchangeDirectoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeDirectoryUri)), __LINE__);
        }
        $this->exchangeDirectoryUri = $exchangeDirectoryUri;
        return $this;
    }
    /**
     * Get routeString value
     * @return string|null
     */
    public function getRouteString()
    {
        return $this->routeString;
    }
    /**
     * Set routeString value
     * @param string $routeString
     * @return \StructType\UpdateInterClusterDirectoryUriReq
     */
    public function setRouteString($routeString = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($routeString) && strlen($routeString) > 50) || (is_array($routeString) && count($routeString) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($routeString) ? strlen($routeString) : count($routeString)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeString) && !is_string($routeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeString)), __LINE__);
        }
        $this->routeString = $routeString;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateInterClusterDirectoryUriReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
