<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGatekeeperReq StructType
 * @subpackage Structs
 */
class UpdateGatekeeperReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - documentation: From Device Table
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: From Device Table
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The rrqTimeToLive
     * Meta informations extracted from the WSDL
     * - default: 60
     * - documentation: Value should be numbers in range of 30 to 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rrqTimeToLive;
    /**
     * The retryTimeout
     * Meta informations extracted from the WSDL
     * - default: 300
     * - documentation: Value should be numbers in range of 30 to 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $retryTimeout;
    /**
     * The enableDevice
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDevice;
    /**
     * Constructor method for UpdateGatekeeperReq
     * @uses UpdateGatekeeperReq::setNewName()
     * @uses UpdateGatekeeperReq::setDescription()
     * @uses UpdateGatekeeperReq::setRrqTimeToLive()
     * @uses UpdateGatekeeperReq::setRetryTimeout()
     * @uses UpdateGatekeeperReq::setEnableDevice()
     * @param string $newName
     * @param string $description
     * @param string $rrqTimeToLive
     * @param string $retryTimeout
     * @param string $enableDevice
     */
    public function __construct($newName = null, $description = null, $rrqTimeToLive = '60', $retryTimeout = '300', $enableDevice = true)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setRrqTimeToLive($rrqTimeToLive)
            ->setRetryTimeout($retryTimeout)
            ->setEnableDevice($enableDevice);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 128) || (is_array($newName) && count($newName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get rrqTimeToLive value
     * @return string|null
     */
    public function getRrqTimeToLive()
    {
        return $this->rrqTimeToLive;
    }
    /**
     * Set rrqTimeToLive value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rrqTimeToLive
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setRrqTimeToLive($rrqTimeToLive = '60')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($rrqTimeToLive)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rrqTimeToLive, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rrqTimeToLive = $rrqTimeToLive;
        return $this;
    }
    /**
     * Get retryTimeout value
     * @return string|null
     */
    public function getRetryTimeout()
    {
        return $this->retryTimeout;
    }
    /**
     * Set retryTimeout value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryTimeout
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setRetryTimeout($retryTimeout = '300')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($retryTimeout)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retryTimeout, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->retryTimeout = $retryTimeout;
        return $this;
    }
    /**
     * Get enableDevice value
     * @return string|null
     */
    public function getEnableDevice()
    {
        return $this->enableDevice;
    }
    /**
     * Set enableDevice value
     * @param string $enableDevice
     * @return \StructType\UpdateGatekeeperReq
     */
    public function setEnableDevice($enableDevice = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enableDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableDevice) && !is_string($enableDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableDevice)), __LINE__);
        }
        $this->enableDevice = $enableDevice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateGatekeeperReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
