<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEnterpriseFeatureAccessConfigurationReq StructType
 * @subpackage Structs
 */
class UpdateEnterpriseFeatureAccessConfigurationReq extends APIRequest
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The newPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $newPattern;
    /**
     * The newRoutePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $newRoutePartitionName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isDefaultEafNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefaultEafNumber;
    /**
     * Constructor method for UpdateEnterpriseFeatureAccessConfigurationReq
     * @uses UpdateEnterpriseFeatureAccessConfigurationReq::setPattern()
     * @uses UpdateEnterpriseFeatureAccessConfigurationReq::setUuid()
     * @uses UpdateEnterpriseFeatureAccessConfigurationReq::setRoutePartitionName()
     * @uses UpdateEnterpriseFeatureAccessConfigurationReq::setNewPattern()
     * @uses UpdateEnterpriseFeatureAccessConfigurationReq::setNewRoutePartitionName()
     * @uses UpdateEnterpriseFeatureAccessConfigurationReq::setDescription()
     * @uses UpdateEnterpriseFeatureAccessConfigurationReq::setIsDefaultEafNumber()
     * @param string $pattern
     * @param string $uuid
     * @param \StructType\XFkType $routePartitionName
     * @param string $newPattern
     * @param \StructType\XFkType $newRoutePartitionName
     * @param string $description
     * @param string $isDefaultEafNumber
     */
    public function __construct($pattern = null, $uuid = null, \StructType\XFkType $routePartitionName = null, $newPattern = null, \StructType\XFkType $newRoutePartitionName = null, $description = null, $isDefaultEafNumber = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setRoutePartitionName($routePartitionName)
            ->setNewPattern($newPattern)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setDescription($description)
            ->setIsDefaultEafNumber($isDefaultEafNumber);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\UpdateEnterpriseFeatureAccessConfigurationReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pattern) && strlen($pattern) > 16) || (is_array($pattern) && count($pattern) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($pattern) ? strlen($pattern) : count($pattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateEnterpriseFeatureAccessConfigurationReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\UpdateEnterpriseFeatureAccessConfigurationReq
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \StructType\UpdateEnterpriseFeatureAccessConfigurationReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newPattern) && strlen($newPattern) > 16) || (is_array($newPattern) && count($newPattern) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($newPattern) ? strlen($newPattern) : count($newPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $newRoutePartitionName
     * @return \StructType\UpdateEnterpriseFeatureAccessConfigurationReq
     */
    public function setNewRoutePartitionName(\StructType\XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateEnterpriseFeatureAccessConfigurationReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefaultEafNumber value
     * @return string|null
     */
    public function getIsDefaultEafNumber()
    {
        return $this->isDefaultEafNumber;
    }
    /**
     * Set isDefaultEafNumber value
     * @param string $isDefaultEafNumber
     * @return \StructType\UpdateEnterpriseFeatureAccessConfigurationReq
     */
    public function setIsDefaultEafNumber($isDefaultEafNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefaultEafNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefaultEafNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefaultEafNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefaultEafNumber) && !is_string($isDefaultEafNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefaultEafNumber)), __LINE__);
        }
        $this->isDefaultEafNumber = $isDefaultEafNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateEnterpriseFeatureAccessConfigurationReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
