<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDeviceMobilityReq StructType
 * @subpackage Structs
 */
class UpdateDeviceMobilityReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The subNet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subNet;
    /**
     * The subNetMaskSz
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subNetMaskSz;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * Constructor method for UpdateDeviceMobilityReq
     * @uses UpdateDeviceMobilityReq::setNewName()
     * @uses UpdateDeviceMobilityReq::setSubNet()
     * @uses UpdateDeviceMobilityReq::setSubNetMaskSz()
     * @uses UpdateDeviceMobilityReq::setRemoveMembers()
     * @uses UpdateDeviceMobilityReq::setAddMembers()
     * @uses UpdateDeviceMobilityReq::setMembers()
     * @param string $newName
     * @param string $subNet
     * @param string $subNetMaskSz
     * @param \StructType\RemoveMembers $removeMembers
     * @param \StructType\AddMembers $addMembers
     * @param \StructType\Members $members
     */
    public function __construct($newName = null, $subNet = null, $subNetMaskSz = null, \StructType\RemoveMembers $removeMembers = null, \StructType\AddMembers $addMembers = null, \StructType\Members $members = null)
    {
        $this
            ->setNewName($newName)
            ->setSubNet($subNet)
            ->setSubNetMaskSz($subNetMaskSz)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateDeviceMobilityReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get subNet value
     * @return string|null
     */
    public function getSubNet()
    {
        return $this->subNet;
    }
    /**
     * Set subNet value
     * @param string $subNet
     * @return \StructType\UpdateDeviceMobilityReq
     */
    public function setSubNet($subNet = null)
    {
        // validation for constraint: string
        if (!is_null($subNet) && !is_string($subNet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subNet)), __LINE__);
        }
        $this->subNet = $subNet;
        return $this;
    }
    /**
     * Get subNetMaskSz value
     * @return string|null
     */
    public function getSubNetMaskSz()
    {
        return $this->subNetMaskSz;
    }
    /**
     * Set subNetMaskSz value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subNetMaskSz
     * @return \StructType\UpdateDeviceMobilityReq
     */
    public function setSubNetMaskSz($subNetMaskSz = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($subNetMaskSz)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subNetMaskSz, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->subNetMaskSz = $subNetMaskSz;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \StructType\RemoveMembers $removeMembers
     * @return \StructType\UpdateDeviceMobilityReq
     */
    public function setRemoveMembers(\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \StructType\AddMembers $addMembers
     * @return \StructType\UpdateDeviceMobilityReq
     */
    public function setAddMembers(\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\UpdateDeviceMobilityReq
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateDeviceMobilityReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
