<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCommonDeviceConfigReq StructType
 * @subpackage Structs
 */
class UpdateCommonDeviceConfigReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - documentation: Nullable. The value accepted and retrieved from the database for this field will be of type XUserLocale in AXLEnums.xsd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affect devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This setting only affect devices that support MLPP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Default is not applicable for CommonDeviceConfig API
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This setting only affect devices that support MLPP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The ipAddressingMode
     * Meta informations extracted from the WSDL
     * - default: IPv4 and IPv6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddressingMode;
    /**
     * The ipAddressingModePreferenceControl
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddressingModePreferenceControl;
    /**
     * The allowAutoConfigurationForPhones
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $allowAutoConfigurationForPhones;
    /**
     * The useImeForOutboundCalls
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useImeForOutboundCalls;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The allowDuplicateAddressDetection
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $allowDuplicateAddressDetection;
    /**
     * The acceptRedirectMessages
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $acceptRedirectMessages;
    /**
     * The replyMulticastEchoRequest
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $replyMulticastEchoRequest;
    /**
     * Constructor method for UpdateCommonDeviceConfigReq
     * @uses UpdateCommonDeviceConfigReq::setNewName()
     * @uses UpdateCommonDeviceConfigReq::setSoftkeyTemplateName()
     * @uses UpdateCommonDeviceConfigReq::setUserLocale()
     * @uses UpdateCommonDeviceConfigReq::setNetworkHoldMohAudioSourceId()
     * @uses UpdateCommonDeviceConfigReq::setUserHoldMohAudioSourceId()
     * @uses UpdateCommonDeviceConfigReq::setMlppDomainId()
     * @uses UpdateCommonDeviceConfigReq::setMlppIndicationStatus()
     * @uses UpdateCommonDeviceConfigReq::setUseTrustedRelayPoint()
     * @uses UpdateCommonDeviceConfigReq::setPreemption()
     * @uses UpdateCommonDeviceConfigReq::setIpAddressingMode()
     * @uses UpdateCommonDeviceConfigReq::setIpAddressingModePreferenceControl()
     * @uses UpdateCommonDeviceConfigReq::setAllowAutoConfigurationForPhones()
     * @uses UpdateCommonDeviceConfigReq::setUseImeForOutboundCalls()
     * @uses UpdateCommonDeviceConfigReq::setConfidentialAccess()
     * @uses UpdateCommonDeviceConfigReq::setAllowDuplicateAddressDetection()
     * @uses UpdateCommonDeviceConfigReq::setAcceptRedirectMessages()
     * @uses UpdateCommonDeviceConfigReq::setReplyMulticastEchoRequest()
     * @param string $newName
     * @param \StructType\XFkType $softkeyTemplateName
     * @param string $userLocale
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $useTrustedRelayPoint
     * @param string $preemption
     * @param string $ipAddressingMode
     * @param string $ipAddressingModePreferenceControl
     * @param string $allowAutoConfigurationForPhones
     * @param string $useImeForOutboundCalls
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param string $allowDuplicateAddressDetection
     * @param string $acceptRedirectMessages
     * @param string $replyMulticastEchoRequest
     */
    public function __construct($newName = null, \StructType\XFkType $softkeyTemplateName = null, $userLocale = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $mlppDomainId = null, $mlppIndicationStatus = 'Default', $useTrustedRelayPoint = false, $preemption = 'Default', $ipAddressingMode = 'IPv4 and IPv6', $ipAddressingModePreferenceControl = 'Use System Default', $allowAutoConfigurationForPhones = 'Default', $useImeForOutboundCalls = 'Default', \StructType\ConfidentialAccess $confidentialAccess = null, $allowDuplicateAddressDetection = 'Default', $acceptRedirectMessages = 'Default', $replyMulticastEchoRequest = 'Default')
    {
        $this
            ->setNewName($newName)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setUserLocale($userLocale)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setPreemption($preemption)
            ->setIpAddressingMode($ipAddressingMode)
            ->setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl)
            ->setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones)
            ->setUseImeForOutboundCalls($useImeForOutboundCalls)
            ->setConfidentialAccess($confidentialAccess)
            ->setAllowDuplicateAddressDetection($allowDuplicateAddressDetection)
            ->setAcceptRedirectMessages($acceptRedirectMessages)
            ->setReplyMulticastEchoRequest($replyMulticastEchoRequest);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return isset($this->softkeyTemplateName) ? $this->softkeyTemplateName : null;
    }
    /**
     * Set softkeyTemplateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $softkeyTemplateName
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setSoftkeyTemplateName(\StructType\XFkType $softkeyTemplateName = null)
    {
        if (is_null($softkeyTemplateName) || (is_array($softkeyTemplateName) && empty($softkeyTemplateName))) {
            unset($this->softkeyTemplateName);
        } else {
            $this->softkeyTemplateName = $softkeyTemplateName;
        }
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XUserLocale::valueIsValid()
     * @uses \EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', \EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = false)
    {
        // validation for constraint: pattern
        if (is_scalar($useTrustedRelayPoint) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useTrustedRelayPoint, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useTrustedRelayPoint) && !is_string($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useTrustedRelayPoint)), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setPreemption($preemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get ipAddressingMode value
     * @return string|null
     */
    public function getIpAddressingMode()
    {
        return $this->ipAddressingMode;
    }
    /**
     * Set ipAddressingMode value
     * @uses \EnumType\XIPAddressingMode::valueIsValid()
     * @uses \EnumType\XIPAddressingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressingMode
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setIpAddressingMode($ipAddressingMode = 'IPv4 and IPv6')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XIPAddressingMode::valueIsValid($ipAddressingMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ipAddressingMode, implode(', ', \EnumType\XIPAddressingMode::getValidValues())), __LINE__);
        }
        $this->ipAddressingMode = $ipAddressingMode;
        return $this;
    }
    /**
     * Get ipAddressingModePreferenceControl value
     * @return string|null
     */
    public function getIpAddressingModePreferenceControl()
    {
        return $this->ipAddressingModePreferenceControl;
    }
    /**
     * Set ipAddressingModePreferenceControl value
     * @uses \EnumType\XIPAddressingModePrefControl::valueIsValid()
     * @uses \EnumType\XIPAddressingModePrefControl::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressingModePreferenceControl
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XIPAddressingModePrefControl::valueIsValid($ipAddressingModePreferenceControl)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ipAddressingModePreferenceControl, implode(', ', \EnumType\XIPAddressingModePrefControl::getValidValues())), __LINE__);
        }
        $this->ipAddressingModePreferenceControl = $ipAddressingModePreferenceControl;
        return $this;
    }
    /**
     * Get allowAutoConfigurationForPhones value
     * @return string|null
     */
    public function getAllowAutoConfigurationForPhones()
    {
        return $this->allowAutoConfigurationForPhones;
    }
    /**
     * Set allowAutoConfigurationForPhones value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allowAutoConfigurationForPhones
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($allowAutoConfigurationForPhones)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allowAutoConfigurationForPhones, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->allowAutoConfigurationForPhones = $allowAutoConfigurationForPhones;
        return $this;
    }
    /**
     * Get useImeForOutboundCalls value
     * @return string|null
     */
    public function getUseImeForOutboundCalls()
    {
        return $this->useImeForOutboundCalls;
    }
    /**
     * Set useImeForOutboundCalls value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useImeForOutboundCalls
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setUseImeForOutboundCalls($useImeForOutboundCalls = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useImeForOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useImeForOutboundCalls, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useImeForOutboundCalls = $useImeForOutboundCalls;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get allowDuplicateAddressDetection value
     * @return string|null
     */
    public function getAllowDuplicateAddressDetection()
    {
        return $this->allowDuplicateAddressDetection;
    }
    /**
     * Set allowDuplicateAddressDetection value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allowDuplicateAddressDetection
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setAllowDuplicateAddressDetection($allowDuplicateAddressDetection = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($allowDuplicateAddressDetection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allowDuplicateAddressDetection, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->allowDuplicateAddressDetection = $allowDuplicateAddressDetection;
        return $this;
    }
    /**
     * Get acceptRedirectMessages value
     * @return string|null
     */
    public function getAcceptRedirectMessages()
    {
        return $this->acceptRedirectMessages;
    }
    /**
     * Set acceptRedirectMessages value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptRedirectMessages
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setAcceptRedirectMessages($acceptRedirectMessages = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($acceptRedirectMessages)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $acceptRedirectMessages, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->acceptRedirectMessages = $acceptRedirectMessages;
        return $this;
    }
    /**
     * Get replyMulticastEchoRequest value
     * @return string|null
     */
    public function getReplyMulticastEchoRequest()
    {
        return $this->replyMulticastEchoRequest;
    }
    /**
     * Set replyMulticastEchoRequest value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $replyMulticastEchoRequest
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public function setReplyMulticastEchoRequest($replyMulticastEchoRequest = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($replyMulticastEchoRequest)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $replyMulticastEchoRequest, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->replyMulticastEchoRequest = $replyMulticastEchoRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCommonDeviceConfigReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
