<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateApplicationServerReq StructType
 * @subpackage Structs
 */
class UpdateApplicationServerReq extends APIRequest
{
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The removeAppUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveAppUsers
     */
    public $removeAppUsers;
    /**
     * The addAppUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddAppUsers
     */
    public $addAppUsers;
    /**
     * The appUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AppUsers
     */
    public $appUsers;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $url;
    /**
     * The endUserUrl
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server, CER Location Management
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endUserUrl;
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - documentation: Applicable Only for Cisco Web dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $processNodeName;
    /**
     * The removeEndUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveEndUsers
     */
    public $removeEndUsers;
    /**
     * The addEndUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddEndUsers
     */
    public $addEndUsers;
    /**
     * The endUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EndUsers
     */
    public $endUsers;
    /**
     * Constructor method for UpdateApplicationServerReq
     * @uses UpdateApplicationServerReq::setUuid()
     * @uses UpdateApplicationServerReq::setNewName()
     * @uses UpdateApplicationServerReq::setIpAddress()
     * @uses UpdateApplicationServerReq::setRemoveAppUsers()
     * @uses UpdateApplicationServerReq::setAddAppUsers()
     * @uses UpdateApplicationServerReq::setAppUsers()
     * @uses UpdateApplicationServerReq::setUrl()
     * @uses UpdateApplicationServerReq::setEndUserUrl()
     * @uses UpdateApplicationServerReq::setProcessNodeName()
     * @uses UpdateApplicationServerReq::setRemoveEndUsers()
     * @uses UpdateApplicationServerReq::setAddEndUsers()
     * @uses UpdateApplicationServerReq::setEndUsers()
     * @param string $uuid
     * @param string $newName
     * @param string $ipAddress
     * @param \StructType\RemoveAppUsers $removeAppUsers
     * @param \StructType\AddAppUsers $addAppUsers
     * @param \StructType\AppUsers $appUsers
     * @param string $url
     * @param string $endUserUrl
     * @param \StructType\XFkType $processNodeName
     * @param \StructType\RemoveEndUsers $removeEndUsers
     * @param \StructType\AddEndUsers $addEndUsers
     * @param \StructType\EndUsers $endUsers
     */
    public function __construct($uuid = null, $newName = null, $ipAddress = null, \StructType\RemoveAppUsers $removeAppUsers = null, \StructType\AddAppUsers $addAppUsers = null, \StructType\AppUsers $appUsers = null, $url = null, $endUserUrl = null, \StructType\XFkType $processNodeName = null, \StructType\RemoveEndUsers $removeEndUsers = null, \StructType\AddEndUsers $addEndUsers = null, \StructType\EndUsers $endUsers = null)
    {
        $this
            ->setUuid($uuid)
            ->setNewName($newName)
            ->setIpAddress($ipAddress)
            ->setRemoveAppUsers($removeAppUsers)
            ->setAddAppUsers($addAppUsers)
            ->setAppUsers($appUsers)
            ->setUrl($url)
            ->setEndUserUrl($endUserUrl)
            ->setProcessNodeName($processNodeName)
            ->setRemoveEndUsers($removeEndUsers)
            ->setAddEndUsers($addEndUsers)
            ->setEndUsers($endUsers);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get removeAppUsers value
     * @return \StructType\RemoveAppUsers|null
     */
    public function getRemoveAppUsers()
    {
        return $this->removeAppUsers;
    }
    /**
     * Set removeAppUsers value
     * @param \StructType\RemoveAppUsers $removeAppUsers
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setRemoveAppUsers(\StructType\RemoveAppUsers $removeAppUsers = null)
    {
        $this->removeAppUsers = $removeAppUsers;
        return $this;
    }
    /**
     * Get addAppUsers value
     * @return \StructType\AddAppUsers|null
     */
    public function getAddAppUsers()
    {
        return $this->addAppUsers;
    }
    /**
     * Set addAppUsers value
     * @param \StructType\AddAppUsers $addAppUsers
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setAddAppUsers(\StructType\AddAppUsers $addAppUsers = null)
    {
        $this->addAppUsers = $addAppUsers;
        return $this;
    }
    /**
     * Get appUsers value
     * @return \StructType\AppUsers|null
     */
    public function getAppUsers()
    {
        return $this->appUsers;
    }
    /**
     * Set appUsers value
     * @param \StructType\AppUsers $appUsers
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setAppUsers(\StructType\AppUsers $appUsers = null)
    {
        $this->appUsers = $appUsers;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get endUserUrl value
     * @return string|null
     */
    public function getEndUserUrl()
    {
        return $this->endUserUrl;
    }
    /**
     * Set endUserUrl value
     * @param string $endUserUrl
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setEndUserUrl($endUserUrl = null)
    {
        // validation for constraint: string
        if (!is_null($endUserUrl) && !is_string($endUserUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endUserUrl)), __LINE__);
        }
        $this->endUserUrl = $endUserUrl;
        return $this;
    }
    /**
     * Get processNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return isset($this->processNodeName) ? $this->processNodeName : null;
    }
    /**
     * Set processNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $processNodeName
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setProcessNodeName(\StructType\XFkType $processNodeName = null)
    {
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->processNodeName);
        } else {
            $this->processNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get removeEndUsers value
     * @return \StructType\RemoveEndUsers|null
     */
    public function getRemoveEndUsers()
    {
        return $this->removeEndUsers;
    }
    /**
     * Set removeEndUsers value
     * @param \StructType\RemoveEndUsers $removeEndUsers
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setRemoveEndUsers(\StructType\RemoveEndUsers $removeEndUsers = null)
    {
        $this->removeEndUsers = $removeEndUsers;
        return $this;
    }
    /**
     * Get addEndUsers value
     * @return \StructType\AddEndUsers|null
     */
    public function getAddEndUsers()
    {
        return $this->addEndUsers;
    }
    /**
     * Set addEndUsers value
     * @param \StructType\AddEndUsers $addEndUsers
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setAddEndUsers(\StructType\AddEndUsers $addEndUsers = null)
    {
        $this->addEndUsers = $addEndUsers;
        return $this;
    }
    /**
     * Get endUsers value
     * @return \StructType\EndUsers|null
     */
    public function getEndUsers()
    {
        return $this->endUsers;
    }
    /**
     * Set endUsers value
     * @param \StructType\EndUsers $endUsers
     * @return \StructType\UpdateApplicationServerReq
     */
    public function setEndUsers(\StructType\EndUsers $endUsers = null)
    {
        $this->endUsers = $endUsers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateApplicationServerReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
