<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for roles StructType
 * @subpackage Structs
 */
class Roles extends AbstractStructBase
{
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XCertificateRole[]
     */
    public $role;
    /**
     * Constructor method for roles
     * @uses Roles::setRole()
     * @param \StructType\XCertificateRole[] $role
     */
    public function __construct(array $role = array())
    {
        $this
            ->setRole($role);
    }
    /**
     * Get role value
     * @return \StructType\XCertificateRole[]|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @throws \InvalidArgumentException
     * @param \StructType\XCertificateRole[] $role
     * @return \StructType\Roles
     */
    public function setRole(array $role = array())
    {
        foreach ($role as $rolesRoleItem) {
            // validation for constraint: itemType
            if (!$rolesRoleItem instanceof \StructType\XCertificateRole) {
                throw new \InvalidArgumentException(sprintf('The role property can only contain items of \StructType\XCertificateRole, "%s" given', is_object($rolesRoleItem) ? get_class($rolesRoleItem) : gettype($rolesRoleItem)), __LINE__);
            }
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Add item to role value
     * @throws \InvalidArgumentException
     * @param \StructType\XCertificateRole $item
     * @return \StructType\Roles
     */
    public function addToRole(\StructType\XCertificateRole $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XCertificateRole) {
            throw new \InvalidArgumentException(sprintf('The role property can only contain items of \StructType\XCertificateRole, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->role[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Roles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
