<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveCcdHostedDNReq StructType
 * @subpackage Structs
 */
class RemoveCcdHostedDNReq extends AbstractStructBase
{
    /**
     * The hostedPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $hostedPattern;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveCcdHostedDNReq
     * @uses RemoveCcdHostedDNReq::setHostedPattern()
     * @uses RemoveCcdHostedDNReq::setUuid()
     * @uses RemoveCcdHostedDNReq::setSequence()
     * @param string $hostedPattern
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($hostedPattern = null, $uuid = null, $sequence = null)
    {
        $this
            ->setHostedPattern($hostedPattern)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get hostedPattern value
     * @return string
     */
    public function getHostedPattern()
    {
        return $this->hostedPattern;
    }
    /**
     * Set hostedPattern value
     * @param string $hostedPattern
     * @return \StructType\RemoveCcdHostedDNReq
     */
    public function setHostedPattern($hostedPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hostedPattern) && strlen($hostedPattern) > 50) || (is_array($hostedPattern) && count($hostedPattern) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($hostedPattern) ? strlen($hostedPattern) : count($hostedPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hostedPattern) && !is_string($hostedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostedPattern)), __LINE__);
        }
        $this->hostedPattern = $hostedPattern;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RemoveCcdHostedDNReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\RemoveCcdHostedDNReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveCcdHostedDNReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
