<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedPolicies StructType
 * @subpackage Structs
 */
class RelatedPolicies extends XCommonMembersExtension
{
    /**
     * The relatedPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XPolicyRelationship[]
     */
    public $relatedPolicy;
    /**
     * Constructor method for relatedPolicies
     * @uses RelatedPolicies::setRelatedPolicy()
     * @param \StructType\XPolicyRelationship[] $relatedPolicy
     */
    public function __construct(array $relatedPolicy = array())
    {
        $this
            ->setRelatedPolicy($relatedPolicy);
    }
    /**
     * Get relatedPolicy value
     * @return \StructType\XPolicyRelationship[]|null
     */
    public function getRelatedPolicy()
    {
        return $this->relatedPolicy;
    }
    /**
     * Set relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\XPolicyRelationship[] $relatedPolicy
     * @return \StructType\RelatedPolicies
     */
    public function setRelatedPolicy(array $relatedPolicy = array())
    {
        foreach ($relatedPolicy as $relatedPoliciesRelatedPolicyItem) {
            // validation for constraint: itemType
            if (!$relatedPoliciesRelatedPolicyItem instanceof \StructType\XPolicyRelationship) {
                throw new \InvalidArgumentException(sprintf('The relatedPolicy property can only contain items of \StructType\XPolicyRelationship, "%s" given', is_object($relatedPoliciesRelatedPolicyItem) ? get_class($relatedPoliciesRelatedPolicyItem) : gettype($relatedPoliciesRelatedPolicyItem)), __LINE__);
            }
        }
        $this->relatedPolicy = $relatedPolicy;
        return $this;
    }
    /**
     * Add item to relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\XPolicyRelationship $item
     * @return \StructType\RelatedPolicies
     */
    public function addToRelatedPolicy(\StructType\XPolicyRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XPolicyRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedPolicy property can only contain items of \StructType\XPolicyRelationship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedPolicy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelatedPolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
