<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPickupGroupMember StructType
 * @subpackage Structs
 */
class RPickupGroupMember extends AbstractStructBase
{
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The pickupGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $pickupGroupName;
    /**
     * The pickupDnAndPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PickupDnAndPartition
     */
    public $pickupDnAndPartition;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPickupGroupMember
     * @uses RPickupGroupMember::setPriority()
     * @uses RPickupGroupMember::setPickupGroupName()
     * @uses RPickupGroupMember::setPickupDnAndPartition()
     * @uses RPickupGroupMember::setUuid()
     * @param string $priority
     * @param \StructType\XFkType $pickupGroupName
     * @param \StructType\PickupDnAndPartition $pickupDnAndPartition
     * @param string $uuid
     */
    public function __construct($priority = null, \StructType\XFkType $pickupGroupName = null, \StructType\PickupDnAndPartition $pickupDnAndPartition = null, $uuid = null)
    {
        $this
            ->setPriority($priority)
            ->setPickupGroupName($pickupGroupName)
            ->setPickupDnAndPartition($pickupDnAndPartition)
            ->setUuid($uuid);
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\RPickupGroupMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get pickupGroupName value
     * @return \StructType\XFkType|null
     */
    public function getPickupGroupName()
    {
        return $this->pickupGroupName;
    }
    /**
     * Set pickupGroupName value
     * @param \StructType\XFkType $pickupGroupName
     * @return \StructType\RPickupGroupMember
     */
    public function setPickupGroupName(\StructType\XFkType $pickupGroupName = null)
    {
        $this->pickupGroupName = $pickupGroupName;
        return $this;
    }
    /**
     * Get pickupDnAndPartition value
     * @return \StructType\PickupDnAndPartition|null
     */
    public function getPickupDnAndPartition()
    {
        return $this->pickupDnAndPartition;
    }
    /**
     * Set pickupDnAndPartition value
     * @param \StructType\PickupDnAndPartition $pickupDnAndPartition
     * @return \StructType\RPickupGroupMember
     */
    public function setPickupDnAndPartition(\StructType\PickupDnAndPartition $pickupDnAndPartition = null)
    {
        $this->pickupDnAndPartition = $pickupDnAndPartition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RPickupGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RPickupGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
