<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPageLayoutPreferences StructType
 * @subpackage Structs
 */
class RPageLayoutPreferences extends AbstractStructBase
{
    /**
     * The pageName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageName;
    /**
     * The pageSections
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PageSections
     */
    public $pageSections;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPageLayoutPreferences
     * @uses RPageLayoutPreferences::setPageName()
     * @uses RPageLayoutPreferences::setPageSections()
     * @uses RPageLayoutPreferences::setUuid()
     * @param string $pageName
     * @param \StructType\PageSections $pageSections
     * @param string $uuid
     */
    public function __construct($pageName = null, \StructType\PageSections $pageSections = null, $uuid = null)
    {
        $this
            ->setPageName($pageName)
            ->setPageSections($pageSections)
            ->setUuid($uuid);
    }
    /**
     * Get pageName value
     * @return string|null
     */
    public function getPageName()
    {
        return $this->pageName;
    }
    /**
     * Set pageName value
     * @param string $pageName
     * @return \StructType\RPageLayoutPreferences
     */
    public function setPageName($pageName = null)
    {
        // validation for constraint: string
        if (!is_null($pageName) && !is_string($pageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageName)), __LINE__);
        }
        $this->pageName = $pageName;
        return $this;
    }
    /**
     * Get pageSections value
     * @return \StructType\PageSections|null
     */
    public function getPageSections()
    {
        return $this->pageSections;
    }
    /**
     * Set pageSections value
     * @param \StructType\PageSections $pageSections
     * @return \StructType\RPageLayoutPreferences
     */
    public function setPageSections(\StructType\PageSections $pageSections = null)
    {
        $this->pageSections = $pageSections;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RPageLayoutPreferences
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RPageLayoutPreferences
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
