<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RNetworkAccessProfile StructType
 * @subpackage Structs
 */
class RNetworkAccessProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The vpnRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vpnRequired;
    /**
     * The proxySettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxySettings;
    /**
     * The proxyHostname
     * Meta informations extracted from the WSDL
     * - documentation: This tag corresponds to Proxy Auto-Config (PAC) Location when proxy setting is set to Auto
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxyHostname;
    /**
     * The proxyPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxyPort;
    /**
     * The proxyRequiresAuthentication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $proxyRequiresAuthentication;
    /**
     * The provideSharedCredentials
     * Meta informations extracted from the WSDL
     * - documentation: This tag is used for validation and does not correspond to any field in database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideSharedCredentials;
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RNetworkAccessProfile
     * @uses RNetworkAccessProfile::setName()
     * @uses RNetworkAccessProfile::setDescription()
     * @uses RNetworkAccessProfile::setVpnRequired()
     * @uses RNetworkAccessProfile::setProxySettings()
     * @uses RNetworkAccessProfile::setProxyHostname()
     * @uses RNetworkAccessProfile::setProxyPort()
     * @uses RNetworkAccessProfile::setProxyRequiresAuthentication()
     * @uses RNetworkAccessProfile::setProvideSharedCredentials()
     * @uses RNetworkAccessProfile::setUsername()
     * @uses RNetworkAccessProfile::setPassword()
     * @uses RNetworkAccessProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $vpnRequired
     * @param string $proxySettings
     * @param string $proxyHostname
     * @param string $proxyPort
     * @param string $proxyRequiresAuthentication
     * @param string $provideSharedCredentials
     * @param string $username
     * @param string $password
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $vpnRequired = null, $proxySettings = null, $proxyHostname = null, $proxyPort = null, $proxyRequiresAuthentication = null, $provideSharedCredentials = null, $username = null, $password = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setVpnRequired($vpnRequired)
            ->setProxySettings($proxySettings)
            ->setProxyHostname($proxyHostname)
            ->setProxyPort($proxyPort)
            ->setProxyRequiresAuthentication($proxyRequiresAuthentication)
            ->setProvideSharedCredentials($provideSharedCredentials)
            ->setUsername($username)
            ->setPassword($password)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RNetworkAccessProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RNetworkAccessProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get vpnRequired value
     * @return string|null
     */
    public function getVpnRequired()
    {
        return $this->vpnRequired;
    }
    /**
     * Set vpnRequired value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vpnRequired
     * @return \StructType\RNetworkAccessProfile
     */
    public function setVpnRequired($vpnRequired = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($vpnRequired)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vpnRequired, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->vpnRequired = $vpnRequired;
        return $this;
    }
    /**
     * Get proxySettings value
     * @return string|null
     */
    public function getProxySettings()
    {
        return $this->proxySettings;
    }
    /**
     * Set proxySettings value
     * @uses \EnumType\XHTTPProxy::valueIsValid()
     * @uses \EnumType\XHTTPProxy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $proxySettings
     * @return \StructType\RNetworkAccessProfile
     */
    public function setProxySettings($proxySettings = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHTTPProxy::valueIsValid($proxySettings)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $proxySettings, implode(', ', \EnumType\XHTTPProxy::getValidValues())), __LINE__);
        }
        $this->proxySettings = $proxySettings;
        return $this;
    }
    /**
     * Get proxyHostname value
     * @return string|null
     */
    public function getProxyHostname()
    {
        return $this->proxyHostname;
    }
    /**
     * Set proxyHostname value
     * @param string $proxyHostname
     * @return \StructType\RNetworkAccessProfile
     */
    public function setProxyHostname($proxyHostname = null)
    {
        // validation for constraint: string
        if (!is_null($proxyHostname) && !is_string($proxyHostname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyHostname)), __LINE__);
        }
        $this->proxyHostname = $proxyHostname;
        return $this;
    }
    /**
     * Get proxyPort value
     * @return string|null
     */
    public function getProxyPort()
    {
        return $this->proxyPort;
    }
    /**
     * Set proxyPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $proxyPort
     * @return \StructType\RNetworkAccessProfile
     */
    public function setProxyPort($proxyPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($proxyPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $proxyPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->proxyPort = $proxyPort;
        return $this;
    }
    /**
     * Get proxyRequiresAuthentication value
     * @return string|null
     */
    public function getProxyRequiresAuthentication()
    {
        return $this->proxyRequiresAuthentication;
    }
    /**
     * Set proxyRequiresAuthentication value
     * @param string $proxyRequiresAuthentication
     * @return \StructType\RNetworkAccessProfile
     */
    public function setProxyRequiresAuthentication($proxyRequiresAuthentication = null)
    {
        // validation for constraint: pattern
        if (is_scalar($proxyRequiresAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $proxyRequiresAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($proxyRequiresAuthentication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($proxyRequiresAuthentication) && !is_string($proxyRequiresAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyRequiresAuthentication)), __LINE__);
        }
        $this->proxyRequiresAuthentication = $proxyRequiresAuthentication;
        return $this;
    }
    /**
     * Get provideSharedCredentials value
     * @return string|null
     */
    public function getProvideSharedCredentials()
    {
        return $this->provideSharedCredentials;
    }
    /**
     * Set provideSharedCredentials value
     * @param string $provideSharedCredentials
     * @return \StructType\RNetworkAccessProfile
     */
    public function setProvideSharedCredentials($provideSharedCredentials = null)
    {
        // validation for constraint: pattern
        if (is_scalar($provideSharedCredentials) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideSharedCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($provideSharedCredentials, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($provideSharedCredentials) && !is_string($provideSharedCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provideSharedCredentials)), __LINE__);
        }
        $this->provideSharedCredentials = $provideSharedCredentials;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\RNetworkAccessProfile
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\RNetworkAccessProfile
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RNetworkAccessProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RNetworkAccessProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
