<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeFeatureConfig StructType
 * @subpackage Structs
 */
class RImeFeatureConfig extends AbstractStructBase
{
    /**
     * The preventImeCallsFromAnalogGateways
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $preventImeCallsFromAnalogGateways;
    /**
     * The enableIntraDomain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableIntraDomain;
    /**
     * The allowMwiNotification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowMwiNotification;
    /**
     * The trunkConnectionTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $trunkConnectionTimer;
    /**
     * The firewallConnectionTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firewallConnectionTimer;
    /**
     * The firewallTranscationTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firewallTranscationTimer;
    /**
     * The firewallIdleTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firewallIdleTimer;
    /**
     * The failedCallAttemptThreshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $failedCallAttemptThreshold;
    /**
     * The callFallbackAttemptThreshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callFallbackAttemptThreshold;
    /**
     * The qualityTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qualityTimer;
    /**
     * The useImeForOutboundCalls
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useImeForOutboundCalls;
    /**
     * Constructor method for RImeFeatureConfig
     * @uses RImeFeatureConfig::setPreventImeCallsFromAnalogGateways()
     * @uses RImeFeatureConfig::setEnableIntraDomain()
     * @uses RImeFeatureConfig::setAllowMwiNotification()
     * @uses RImeFeatureConfig::setTrunkConnectionTimer()
     * @uses RImeFeatureConfig::setFirewallConnectionTimer()
     * @uses RImeFeatureConfig::setFirewallTranscationTimer()
     * @uses RImeFeatureConfig::setFirewallIdleTimer()
     * @uses RImeFeatureConfig::setFailedCallAttemptThreshold()
     * @uses RImeFeatureConfig::setCallFallbackAttemptThreshold()
     * @uses RImeFeatureConfig::setQualityTimer()
     * @uses RImeFeatureConfig::setUseImeForOutboundCalls()
     * @param string $preventImeCallsFromAnalogGateways
     * @param string $enableIntraDomain
     * @param string $allowMwiNotification
     * @param string $trunkConnectionTimer
     * @param string $firewallConnectionTimer
     * @param string $firewallTranscationTimer
     * @param string $firewallIdleTimer
     * @param string $failedCallAttemptThreshold
     * @param string $callFallbackAttemptThreshold
     * @param string $qualityTimer
     * @param string $useImeForOutboundCalls
     */
    public function __construct($preventImeCallsFromAnalogGateways = null, $enableIntraDomain = null, $allowMwiNotification = null, $trunkConnectionTimer = null, $firewallConnectionTimer = null, $firewallTranscationTimer = null, $firewallIdleTimer = null, $failedCallAttemptThreshold = null, $callFallbackAttemptThreshold = null, $qualityTimer = null, $useImeForOutboundCalls = null)
    {
        $this
            ->setPreventImeCallsFromAnalogGateways($preventImeCallsFromAnalogGateways)
            ->setEnableIntraDomain($enableIntraDomain)
            ->setAllowMwiNotification($allowMwiNotification)
            ->setTrunkConnectionTimer($trunkConnectionTimer)
            ->setFirewallConnectionTimer($firewallConnectionTimer)
            ->setFirewallTranscationTimer($firewallTranscationTimer)
            ->setFirewallIdleTimer($firewallIdleTimer)
            ->setFailedCallAttemptThreshold($failedCallAttemptThreshold)
            ->setCallFallbackAttemptThreshold($callFallbackAttemptThreshold)
            ->setQualityTimer($qualityTimer)
            ->setUseImeForOutboundCalls($useImeForOutboundCalls);
    }
    /**
     * Get preventImeCallsFromAnalogGateways value
     * @return string|null
     */
    public function getPreventImeCallsFromAnalogGateways()
    {
        return $this->preventImeCallsFromAnalogGateways;
    }
    /**
     * Set preventImeCallsFromAnalogGateways value
     * @param string $preventImeCallsFromAnalogGateways
     * @return \StructType\RImeFeatureConfig
     */
    public function setPreventImeCallsFromAnalogGateways($preventImeCallsFromAnalogGateways = null)
    {
        // validation for constraint: pattern
        if (is_scalar($preventImeCallsFromAnalogGateways) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $preventImeCallsFromAnalogGateways)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($preventImeCallsFromAnalogGateways, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($preventImeCallsFromAnalogGateways) && !is_string($preventImeCallsFromAnalogGateways)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preventImeCallsFromAnalogGateways)), __LINE__);
        }
        $this->preventImeCallsFromAnalogGateways = $preventImeCallsFromAnalogGateways;
        return $this;
    }
    /**
     * Get enableIntraDomain value
     * @return string|null
     */
    public function getEnableIntraDomain()
    {
        return $this->enableIntraDomain;
    }
    /**
     * Set enableIntraDomain value
     * @param string $enableIntraDomain
     * @return \StructType\RImeFeatureConfig
     */
    public function setEnableIntraDomain($enableIntraDomain = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableIntraDomain) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableIntraDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableIntraDomain, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableIntraDomain) && !is_string($enableIntraDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableIntraDomain)), __LINE__);
        }
        $this->enableIntraDomain = $enableIntraDomain;
        return $this;
    }
    /**
     * Get allowMwiNotification value
     * @return string|null
     */
    public function getAllowMwiNotification()
    {
        return $this->allowMwiNotification;
    }
    /**
     * Set allowMwiNotification value
     * @param string $allowMwiNotification
     * @return \StructType\RImeFeatureConfig
     */
    public function setAllowMwiNotification($allowMwiNotification = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowMwiNotification) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowMwiNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowMwiNotification, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowMwiNotification) && !is_string($allowMwiNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowMwiNotification)), __LINE__);
        }
        $this->allowMwiNotification = $allowMwiNotification;
        return $this;
    }
    /**
     * Get trunkConnectionTimer value
     * @return string|null
     */
    public function getTrunkConnectionTimer()
    {
        return $this->trunkConnectionTimer;
    }
    /**
     * Set trunkConnectionTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkConnectionTimer
     * @return \StructType\RImeFeatureConfig
     */
    public function setTrunkConnectionTimer($trunkConnectionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($trunkConnectionTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkConnectionTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->trunkConnectionTimer = $trunkConnectionTimer;
        return $this;
    }
    /**
     * Get firewallConnectionTimer value
     * @return string|null
     */
    public function getFirewallConnectionTimer()
    {
        return $this->firewallConnectionTimer;
    }
    /**
     * Set firewallConnectionTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firewallConnectionTimer
     * @return \StructType\RImeFeatureConfig
     */
    public function setFirewallConnectionTimer($firewallConnectionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($firewallConnectionTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $firewallConnectionTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->firewallConnectionTimer = $firewallConnectionTimer;
        return $this;
    }
    /**
     * Get firewallTranscationTimer value
     * @return string|null
     */
    public function getFirewallTranscationTimer()
    {
        return $this->firewallTranscationTimer;
    }
    /**
     * Set firewallTranscationTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firewallTranscationTimer
     * @return \StructType\RImeFeatureConfig
     */
    public function setFirewallTranscationTimer($firewallTranscationTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($firewallTranscationTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $firewallTranscationTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->firewallTranscationTimer = $firewallTranscationTimer;
        return $this;
    }
    /**
     * Get firewallIdleTimer value
     * @return string|null
     */
    public function getFirewallIdleTimer()
    {
        return $this->firewallIdleTimer;
    }
    /**
     * Set firewallIdleTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firewallIdleTimer
     * @return \StructType\RImeFeatureConfig
     */
    public function setFirewallIdleTimer($firewallIdleTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($firewallIdleTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $firewallIdleTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->firewallIdleTimer = $firewallIdleTimer;
        return $this;
    }
    /**
     * Get failedCallAttemptThreshold value
     * @return string|null
     */
    public function getFailedCallAttemptThreshold()
    {
        return $this->failedCallAttemptThreshold;
    }
    /**
     * Set failedCallAttemptThreshold value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failedCallAttemptThreshold
     * @return \StructType\RImeFeatureConfig
     */
    public function setFailedCallAttemptThreshold($failedCallAttemptThreshold = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($failedCallAttemptThreshold)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $failedCallAttemptThreshold, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->failedCallAttemptThreshold = $failedCallAttemptThreshold;
        return $this;
    }
    /**
     * Get callFallbackAttemptThreshold value
     * @return string|null
     */
    public function getCallFallbackAttemptThreshold()
    {
        return $this->callFallbackAttemptThreshold;
    }
    /**
     * Set callFallbackAttemptThreshold value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callFallbackAttemptThreshold
     * @return \StructType\RImeFeatureConfig
     */
    public function setCallFallbackAttemptThreshold($callFallbackAttemptThreshold = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callFallbackAttemptThreshold)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callFallbackAttemptThreshold, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callFallbackAttemptThreshold = $callFallbackAttemptThreshold;
        return $this;
    }
    /**
     * Get qualityTimer value
     * @return string|null
     */
    public function getQualityTimer()
    {
        return $this->qualityTimer;
    }
    /**
     * Set qualityTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qualityTimer
     * @return \StructType\RImeFeatureConfig
     */
    public function setQualityTimer($qualityTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($qualityTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qualityTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->qualityTimer = $qualityTimer;
        return $this;
    }
    /**
     * Get useImeForOutboundCalls value
     * @return string|null
     */
    public function getUseImeForOutboundCalls()
    {
        return $this->useImeForOutboundCalls;
    }
    /**
     * Set useImeForOutboundCalls value
     * @param string $useImeForOutboundCalls
     * @return \StructType\RImeFeatureConfig
     */
    public function setUseImeForOutboundCalls($useImeForOutboundCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useImeForOutboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useImeForOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useImeForOutboundCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useImeForOutboundCalls) && !is_string($useImeForOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useImeForOutboundCalls)), __LINE__);
        }
        $this->useImeForOutboundCalls = $useImeForOutboundCalls;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RImeFeatureConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
