<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RGatewaySubunits StructType
 * @subpackage Structs
 */
class RGatewaySubunits extends AbstractStructBase
{
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The gatewayUuid
     * Meta informations extracted from the WSDL
     * - documentation: pkid of the Gateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * The subunits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Subunits
     */
    public $subunits;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RGatewaySubunits
     * @uses RGatewaySubunits::setDomainName()
     * @uses RGatewaySubunits::setGatewayUuid()
     * @uses RGatewaySubunits::setUnit()
     * @uses RGatewaySubunits::setSubunits()
     * @uses RGatewaySubunits::setUuid()
     * @param string $domainName
     * @param string $gatewayUuid
     * @param string $unit
     * @param \StructType\Subunits $subunits
     * @param string $uuid
     */
    public function __construct($domainName = null, $gatewayUuid = null, $unit = null, \StructType\Subunits $subunits = null, $uuid = null)
    {
        $this
            ->setDomainName($domainName)
            ->setGatewayUuid($gatewayUuid)
            ->setUnit($unit)
            ->setSubunits($subunits)
            ->setUuid($uuid);
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \StructType\RGatewaySubunits
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get gatewayUuid value
     * @return string|null
     */
    public function getGatewayUuid()
    {
        return $this->gatewayUuid;
    }
    /**
     * Set gatewayUuid value
     * @param string $gatewayUuid
     * @return \StructType\RGatewaySubunits
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gatewayUuid) && !preg_match('/\\{........-....-....-....-............\\}/', $gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($gatewayUuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gatewayUuid) && !is_string($gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gatewayUuid)), __LINE__);
        }
        $this->gatewayUuid = $gatewayUuid;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return \StructType\RGatewaySubunits
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unit, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get subunits value
     * @return \StructType\Subunits|null
     */
    public function getSubunits()
    {
        return $this->subunits;
    }
    /**
     * Set subunits value
     * @param \StructType\Subunits $subunits
     * @return \StructType\RGatewaySubunits
     */
    public function setSubunits(\StructType\Subunits $subunits = null)
    {
        $this->subunits = $subunits;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RGatewaySubunits
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RGatewaySubunits
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
