<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCommunityString StructType
 * @subpackage Structs
 */
class RCommunityString extends AbstractStructBase
{
    /**
     * The communityName
     * @var string
     */
    public $communityName;
    /**
     * The accessPrivilege
     * @var string
     */
    public $accessPrivilege;
    /**
     * The ArrayOfHosts
     * @var \ArrayType\RArrayOfHosts
     */
    public $ArrayOfHosts;
    /**
     * Constructor method for RCommunityString
     * @uses RCommunityString::setCommunityName()
     * @uses RCommunityString::setAccessPrivilege()
     * @uses RCommunityString::setArrayOfHosts()
     * @param string $communityName
     * @param string $accessPrivilege
     * @param \ArrayType\RArrayOfHosts $arrayOfHosts
     */
    public function __construct($communityName = null, $accessPrivilege = null, \ArrayType\RArrayOfHosts $arrayOfHosts = null)
    {
        $this
            ->setCommunityName($communityName)
            ->setAccessPrivilege($accessPrivilege)
            ->setArrayOfHosts($arrayOfHosts);
    }
    /**
     * Get communityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->communityName;
    }
    /**
     * Set communityName value
     * @param string $communityName
     * @return \StructType\RCommunityString
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communityName)), __LINE__);
        }
        $this->communityName = $communityName;
        return $this;
    }
    /**
     * Get accessPrivilege value
     * @return string|null
     */
    public function getAccessPrivilege()
    {
        return $this->accessPrivilege;
    }
    /**
     * Set accessPrivilege value
     * @param string $accessPrivilege
     * @return \StructType\RCommunityString
     */
    public function setAccessPrivilege($accessPrivilege = null)
    {
        // validation for constraint: string
        if (!is_null($accessPrivilege) && !is_string($accessPrivilege)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessPrivilege)), __LINE__);
        }
        $this->accessPrivilege = $accessPrivilege;
        return $this;
    }
    /**
     * Get ArrayOfHosts value
     * @return \ArrayType\RArrayOfHosts|null
     */
    public function getArrayOfHosts()
    {
        return $this->ArrayOfHosts;
    }
    /**
     * Set ArrayOfHosts value
     * @param \ArrayType\RArrayOfHosts $arrayOfHosts
     * @return \StructType\RCommunityString
     */
    public function setArrayOfHosts(\ArrayType\RArrayOfHosts $arrayOfHosts = null)
    {
        $this->ArrayOfHosts = $arrayOfHosts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RCommunityString
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
