<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallManagerMember StructType
 * @subpackage Structs
 */
class RCallManagerMember extends AbstractStructBase
{
    /**
     * The callManagerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callManagerName;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCallManagerMember
     * @uses RCallManagerMember::setCallManagerName()
     * @uses RCallManagerMember::setPriority()
     * @uses RCallManagerMember::setUuid()
     * @param \StructType\XFkType $callManagerName
     * @param string $priority
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $callManagerName = null, $priority = null, $uuid = null)
    {
        $this
            ->setCallManagerName($callManagerName)
            ->setPriority($priority)
            ->setUuid($uuid);
    }
    /**
     * Get callManagerName value
     * @return \StructType\XFkType|null
     */
    public function getCallManagerName()
    {
        return $this->callManagerName;
    }
    /**
     * Set callManagerName value
     * @param \StructType\XFkType $callManagerName
     * @return \StructType\RCallManagerMember
     */
    public function setCallManagerName(\StructType\XFkType $callManagerName = null)
    {
        $this->callManagerName = $callManagerName;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\RCallManagerMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RCallManagerMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RCallManagerMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
