<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RApplicationUserCapfProfile StructType
 * @subpackage Structs
 */
class RApplicationUserCapfProfile extends AbstractStructBase
{
    /**
     * The applicationUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $applicationUser;
    /**
     * The instanceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $instanceId;
    /**
     * The certificateOperation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationString;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The keyOrder
     * Meta informations extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keyOrder;
    /**
     * The ecKeySize
     * Meta informations extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ecKeySize;
    /**
     * The operationCompletion
     * Meta informations extracted from the WSDL
     * - documentation: Required format is YYYY:MM:DD:HH:SS. Read Only when certificateOperation is 'No Pending Operation'. Please provide the above format while adding a new device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operationCompletion;
    /**
     * The certificationOperationStatus
     * Meta informations extracted from the WSDL
     * - documentation: Read-Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificationOperationStatus;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RApplicationUserCapfProfile
     * @uses RApplicationUserCapfProfile::setApplicationUser()
     * @uses RApplicationUserCapfProfile::setInstanceId()
     * @uses RApplicationUserCapfProfile::setCertificateOperation()
     * @uses RApplicationUserCapfProfile::setAuthenticationMode()
     * @uses RApplicationUserCapfProfile::setAuthenticationString()
     * @uses RApplicationUserCapfProfile::setKeySize()
     * @uses RApplicationUserCapfProfile::setKeyOrder()
     * @uses RApplicationUserCapfProfile::setEcKeySize()
     * @uses RApplicationUserCapfProfile::setOperationCompletion()
     * @uses RApplicationUserCapfProfile::setCertificationOperationStatus()
     * @uses RApplicationUserCapfProfile::setUuid()
     * @param \StructType\XFkType $applicationUser
     * @param string $instanceId
     * @param string $certificateOperation
     * @param string $authenticationMode
     * @param string $authenticationString
     * @param string $keySize
     * @param string $keyOrder
     * @param string $ecKeySize
     * @param string $operationCompletion
     * @param string $certificationOperationStatus
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $applicationUser = null, $instanceId = null, $certificateOperation = null, $authenticationMode = null, $authenticationString = null, $keySize = null, $keyOrder = null, $ecKeySize = null, $operationCompletion = null, $certificationOperationStatus = null, $uuid = null)
    {
        $this
            ->setApplicationUser($applicationUser)
            ->setInstanceId($instanceId)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setAuthenticationString($authenticationString)
            ->setKeySize($keySize)
            ->setKeyOrder($keyOrder)
            ->setEcKeySize($ecKeySize)
            ->setOperationCompletion($operationCompletion)
            ->setCertificationOperationStatus($certificationOperationStatus)
            ->setUuid($uuid);
    }
    /**
     * Get applicationUser value
     * @return \StructType\XFkType|null
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \StructType\XFkType $applicationUser
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setApplicationUser(\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get instanceId value
     * @return string|null
     */
    public function getInstanceId()
    {
        return $this->instanceId;
    }
    /**
     * Set instanceId value
     * @param string $instanceId
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instanceId)), __LINE__);
        }
        $this->instanceId = $instanceId;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @uses \EnumType\XCertificateOperation::valueIsValid()
     * @uses \EnumType\XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateOperation
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setCertificateOperation($certificateOperation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateOperation::valueIsValid($certificateOperation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificateOperation, implode(', ', \EnumType\XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \EnumType\XAuthenticationMode::valueIsValid()
     * @uses \EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', \EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \EnumType\XKeySize::valueIsValid()
     * @uses \EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', \EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get keyOrder value
     * @return string|null
     */
    public function getKeyOrder()
    {
        return $this->keyOrder;
    }
    /**
     * Set keyOrder value
     * @uses \EnumType\XKeyOrder::valueIsValid()
     * @uses \EnumType\XKeyOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keyOrder
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setKeyOrder($keyOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeyOrder::valueIsValid($keyOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keyOrder, implode(', ', \EnumType\XKeyOrder::getValidValues())), __LINE__);
        }
        $this->keyOrder = $keyOrder;
        return $this;
    }
    /**
     * Get ecKeySize value
     * @return string|null
     */
    public function getEcKeySize()
    {
        return $this->ecKeySize;
    }
    /**
     * Set ecKeySize value
     * @uses \EnumType\XECKeySize::valueIsValid()
     * @uses \EnumType\XECKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ecKeySize
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setEcKeySize($ecKeySize = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XECKeySize::valueIsValid($ecKeySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ecKeySize, implode(', ', \EnumType\XECKeySize::getValidValues())), __LINE__);
        }
        $this->ecKeySize = $ecKeySize;
        return $this;
    }
    /**
     * Get operationCompletion value
     * @return string|null
     */
    public function getOperationCompletion()
    {
        return $this->operationCompletion;
    }
    /**
     * Set operationCompletion value
     * @param string $operationCompletion
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setOperationCompletion($operationCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($operationCompletion) && !is_string($operationCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationCompletion)), __LINE__);
        }
        $this->operationCompletion = $operationCompletion;
        return $this;
    }
    /**
     * Get certificationOperationStatus value
     * @return string|null
     */
    public function getCertificationOperationStatus()
    {
        return $this->certificationOperationStatus;
    }
    /**
     * Set certificationOperationStatus value
     * @uses \EnumType\XCertificateStatus::valueIsValid()
     * @uses \EnumType\XCertificateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificationOperationStatus
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setCertificationOperationStatus($certificationOperationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateStatus::valueIsValid($certificationOperationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificationOperationStatus, implode(', ', \EnumType\XCertificateStatus::getValidValues())), __LINE__);
        }
        $this->certificationOperationStatus = $certificationOperationStatus;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RApplicationUserCapfProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RApplicationUserCapfProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
