<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for primaryExtension StructType
 * Meta informations extracted from the WSDL
 * - documentation: Only DNs associated with the associatedDevices of the User can be used as primary extension. | Only DNs associated with the associatedDevices of the User can be used as primary extension. | Only DNs associated with the
 * associatedDevices of the User can be used as primary extension. | Only DNs associated with the associatedDevices of the User can be used as primary extension.
 * @subpackage Structs
 */
class PrimaryExtension extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - documentation: DN or Pattern | DN or Pattern | DN or Pattern | DN or Pattern
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - documentation: Route Partition to which the DN is associated. | Route Partition to which the DN is associated. | Route Partition to which the DN is associated. | Route Partition to which the DN is associated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $routePartitionName;
    /**
     * Constructor method for primaryExtension
     * @uses PrimaryExtension::setPattern()
     * @uses PrimaryExtension::setRoutePartitionName()
     * @param string $pattern
     * @param string $routePartitionName
     */
    public function __construct($pattern = null, $routePartitionName = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\PrimaryExtension
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pattern) && strlen($pattern) > 255) || (is_array($pattern) && count($pattern) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($pattern) ? strlen($pattern) : count($pattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return string|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param string $routePartitionName
     * @return \StructType\PrimaryExtension
     */
    public function setRoutePartitionName($routePartitionName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($routePartitionName) && strlen($routePartitionName) > 50) || (is_array($routePartitionName) && count($routePartitionName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($routePartitionName) ? strlen($routePartitionName) : count($routePartitionName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routePartitionName) && !is_string($routePartitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePartitionName)), __LINE__);
        }
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrimaryExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
