<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXSubscribedService StructType
 * @subpackage Structs
 */
class OXSubscribedService extends AbstractStructBase
{
    /**
     * The telecasterServiceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $telecasterServiceName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXSubscribedService
     * @uses OXSubscribedService::setTelecasterServiceName()
     * @uses OXSubscribedService::setUuid()
     * @param \StructType\OXFkType $telecasterServiceName
     * @param string $uuid
     */
    public function __construct(\StructType\OXFkType $telecasterServiceName = null, $uuid = null)
    {
        $this
            ->setTelecasterServiceName($telecasterServiceName)
            ->setUuid($uuid);
    }
    /**
     * Get telecasterServiceName value
     * @return \StructType\OXFkType|null
     */
    public function getTelecasterServiceName()
    {
        return $this->telecasterServiceName;
    }
    /**
     * Set telecasterServiceName value
     * @param \StructType\OXFkType $telecasterServiceName
     * @return \StructType\OXSubscribedService
     */
    public function setTelecasterServiceName(\StructType\OXFkType $telecasterServiceName = null)
    {
        $this->telecasterServiceName = $telecasterServiceName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\OXSubscribedService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OXSubscribedService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
