<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXBLFDirectedCallPark StructType
 * @subpackage Structs
 */
class OXBLFDirectedCallPark extends AbstractStructBase
{
    /**
     * The directedCallParkId
     * Meta informations extracted from the WSDL
     * - documentation: Only the uuid attribute is read
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $directedCallParkId;
    /**
     * The directedCallParkDnAndPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DirectedCallParkDnAndPartition
     */
    public $directedCallParkDnAndPartition;
    /**
     * Constructor method for OXBLFDirectedCallPark
     * @uses OXBLFDirectedCallPark::setDirectedCallParkId()
     * @uses OXBLFDirectedCallPark::setDirectedCallParkDnAndPartition()
     * @param string $directedCallParkId
     * @param \StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     */
    public function __construct($directedCallParkId = null, \StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        $this
            ->setDirectedCallParkId($directedCallParkId)
            ->setDirectedCallParkDnAndPartition($directedCallParkDnAndPartition);
    }
    /**
     * Get directedCallParkId value
     * @return string|null
     */
    public function getDirectedCallParkId()
    {
        return $this->directedCallParkId;
    }
    /**
     * Set directedCallParkId value
     * @param string $directedCallParkId
     * @return \StructType\OXBLFDirectedCallPark
     */
    public function setDirectedCallParkId($directedCallParkId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($directedCallParkId) && !preg_match('/\\{........-....-....-....-............\\}/', $directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($directedCallParkId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directedCallParkId) && !is_string($directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directedCallParkId)), __LINE__);
        }
        $this->directedCallParkId = $directedCallParkId;
        return $this;
    }
    /**
     * Get directedCallParkDnAndPartition value
     * @return \StructType\DirectedCallParkDnAndPartition|null
     */
    public function getDirectedCallParkDnAndPartition()
    {
        return $this->directedCallParkDnAndPartition;
    }
    /**
     * Set directedCallParkDnAndPartition value
     * @param \StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @return \StructType\OXBLFDirectedCallPark
     */
    public function setDirectedCallParkDnAndPartition(\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        $this->directedCallParkDnAndPartition = $directedCallParkDnAndPartition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OXBLFDirectedCallPark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
