<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORSipProfile StructType
 * @subpackage Structs
 */
class ORSipProfile extends AbstractStructBase
{
    /**
     * The userInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $telnetLevel;
    /**
     * The rerouteIncomingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The rsvpOverSip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $rsvpOverSip;
    /**
     * The sipRe11XxEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $gClear;
    /**
     * The sipBandwidthModifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $sipBandwidthModifier;
    /**
     * The userAgentServerHeaderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $userAgentServerHeaderInfo;
    /**
     * The sipNormalizationScript
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $sipNormalizationScript;
    /**
     * The dialStringInterpretation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $acceptAudioCodecPreferences;
    /**
     * The resourcePriorityNamespace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The callingLineIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callingLineIdentification;
    /**
     * The videoCallTrafficClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $videoCallTrafficClass;
    /**
     * The sdpTransparency
     * Meta informations extracted from the WSDL
     * - documentation: SDP Transparency Profile for SIP Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $sdpTransparency;
    /**
     * The sipSessionRefreshMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $sipSessionRefreshMethod;
    /**
     * The earlyOfferSuppVoiceCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $earlyOfferSuppVoiceCall;
    /**
     * The cucmVersionInSipHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $cucmVersionInSipHeader;
    /**
     * The confidentialAccessLevelHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $confidentialAccessLevelHeaders;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORSipProfile
     * @uses ORSipProfile::setUserInfo()
     * @uses ORSipProfile::setDtmfDbLevel()
     * @uses ORSipProfile::setCallHoldRingback()
     * @uses ORSipProfile::setAnonymousCallBlock()
     * @uses ORSipProfile::setCallerIdBlock()
     * @uses ORSipProfile::setDndControl()
     * @uses ORSipProfile::setTelnetLevel()
     * @uses ORSipProfile::setRerouteIncomingRequest()
     * @uses ORSipProfile::setResourcePriorityNamespaceListName()
     * @uses ORSipProfile::setRsvpOverSip()
     * @uses ORSipProfile::setSipRe11XxEnabled()
     * @uses ORSipProfile::setGClear()
     * @uses ORSipProfile::setSipBandwidthModifier()
     * @uses ORSipProfile::setUserAgentServerHeaderInfo()
     * @uses ORSipProfile::setSipNormalizationScript()
     * @uses ORSipProfile::setDialStringInterpretation()
     * @uses ORSipProfile::setAcceptAudioCodecPreferences()
     * @uses ORSipProfile::setResourcePriorityNamespace()
     * @uses ORSipProfile::setCallingLineIdentification()
     * @uses ORSipProfile::setVideoCallTrafficClass()
     * @uses ORSipProfile::setSdpTransparency()
     * @uses ORSipProfile::setSipSessionRefreshMethod()
     * @uses ORSipProfile::setEarlyOfferSuppVoiceCall()
     * @uses ORSipProfile::setCucmVersionInSipHeader()
     * @uses ORSipProfile::setConfidentialAccessLevelHeaders()
     * @uses ORSipProfile::setUuid()
     * @param \StructType\ORFkType $userInfo
     * @param \StructType\ORFkType $dtmfDbLevel
     * @param \StructType\ORFkType $callHoldRingback
     * @param \StructType\ORFkType $anonymousCallBlock
     * @param \StructType\ORFkType $callerIdBlock
     * @param \StructType\ORFkType $dndControl
     * @param \StructType\ORFkType $telnetLevel
     * @param \StructType\ORFkType $rerouteIncomingRequest
     * @param \StructType\ORFkType $resourcePriorityNamespaceListName
     * @param \StructType\ORFkType $rsvpOverSip
     * @param \StructType\ORFkType $sipRe11XxEnabled
     * @param \StructType\ORFkType $gClear
     * @param \StructType\ORFkType $sipBandwidthModifier
     * @param \StructType\ORFkType $userAgentServerHeaderInfo
     * @param \StructType\ORFkType $sipNormalizationScript
     * @param \StructType\ORFkType $dialStringInterpretation
     * @param \StructType\ORFkType $acceptAudioCodecPreferences
     * @param \StructType\ORFkType $resourcePriorityNamespace
     * @param \StructType\ORFkType $callingLineIdentification
     * @param \StructType\ORFkType $videoCallTrafficClass
     * @param \StructType\ORFkType $sdpTransparency
     * @param \StructType\ORFkType $sipSessionRefreshMethod
     * @param \StructType\ORFkType $earlyOfferSuppVoiceCall
     * @param \StructType\ORFkType $cucmVersionInSipHeader
     * @param \StructType\ORFkType $confidentialAccessLevelHeaders
     * @param string $uuid
     */
    public function __construct(\StructType\ORFkType $userInfo = null, \StructType\ORFkType $dtmfDbLevel = null, \StructType\ORFkType $callHoldRingback = null, \StructType\ORFkType $anonymousCallBlock = null, \StructType\ORFkType $callerIdBlock = null, \StructType\ORFkType $dndControl = null, \StructType\ORFkType $telnetLevel = null, \StructType\ORFkType $rerouteIncomingRequest = null, \StructType\ORFkType $resourcePriorityNamespaceListName = null, \StructType\ORFkType $rsvpOverSip = null, \StructType\ORFkType $sipRe11XxEnabled = null, \StructType\ORFkType $gClear = null, \StructType\ORFkType $sipBandwidthModifier = null, \StructType\ORFkType $userAgentServerHeaderInfo = null, \StructType\ORFkType $sipNormalizationScript = null, \StructType\ORFkType $dialStringInterpretation = null, \StructType\ORFkType $acceptAudioCodecPreferences = null, \StructType\ORFkType $resourcePriorityNamespace = null, \StructType\ORFkType $callingLineIdentification = null, \StructType\ORFkType $videoCallTrafficClass = null, \StructType\ORFkType $sdpTransparency = null, \StructType\ORFkType $sipSessionRefreshMethod = null, \StructType\ORFkType $earlyOfferSuppVoiceCall = null, \StructType\ORFkType $cucmVersionInSipHeader = null, \StructType\ORFkType $confidentialAccessLevelHeaders = null, $uuid = null)
    {
        $this
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setRsvpOverSip($rsvpOverSip)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setSdpTransparency($sdpTransparency)
            ->setSipSessionRefreshMethod($sipSessionRefreshMethod)
            ->setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall)
            ->setCucmVersionInSipHeader($cucmVersionInSipHeader)
            ->setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders)
            ->setUuid($uuid);
    }
    /**
     * Get userInfo value
     * @return \StructType\ORFkType|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \StructType\ORFkType $userInfo
     * @return \StructType\ORSipProfile
     */
    public function setUserInfo(\StructType\ORFkType $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return \StructType\ORFkType|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @param \StructType\ORFkType $dtmfDbLevel
     * @return \StructType\ORSipProfile
     */
    public function setDtmfDbLevel(\StructType\ORFkType $dtmfDbLevel = null)
    {
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return \StructType\ORFkType|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @param \StructType\ORFkType $callHoldRingback
     * @return \StructType\ORSipProfile
     */
    public function setCallHoldRingback(\StructType\ORFkType $callHoldRingback = null)
    {
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return \StructType\ORFkType|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @param \StructType\ORFkType $anonymousCallBlock
     * @return \StructType\ORSipProfile
     */
    public function setAnonymousCallBlock(\StructType\ORFkType $anonymousCallBlock = null)
    {
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return \StructType\ORFkType|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @param \StructType\ORFkType $callerIdBlock
     * @return \StructType\ORSipProfile
     */
    public function setCallerIdBlock(\StructType\ORFkType $callerIdBlock = null)
    {
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return \StructType\ORFkType|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @param \StructType\ORFkType $dndControl
     * @return \StructType\ORSipProfile
     */
    public function setDndControl(\StructType\ORFkType $dndControl = null)
    {
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return \StructType\ORFkType|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @param \StructType\ORFkType $telnetLevel
     * @return \StructType\ORSipProfile
     */
    public function setTelnetLevel(\StructType\ORFkType $telnetLevel = null)
    {
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return \StructType\ORFkType|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @param \StructType\ORFkType $rerouteIncomingRequest
     * @return \StructType\ORSipProfile
     */
    public function setRerouteIncomingRequest(\StructType\ORFkType $rerouteIncomingRequest = null)
    {
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return \StructType\ORFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param \StructType\ORFkType $resourcePriorityNamespaceListName
     * @return \StructType\ORSipProfile
     */
    public function setResourcePriorityNamespaceListName(\StructType\ORFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return \StructType\ORFkType|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @param \StructType\ORFkType $rsvpOverSip
     * @return \StructType\ORSipProfile
     */
    public function setRsvpOverSip(\StructType\ORFkType $rsvpOverSip = null)
    {
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return \StructType\ORFkType|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @param \StructType\ORFkType $sipRe11XxEnabled
     * @return \StructType\ORSipProfile
     */
    public function setSipRe11XxEnabled(\StructType\ORFkType $sipRe11XxEnabled = null)
    {
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return \StructType\ORFkType|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @param \StructType\ORFkType $gClear
     * @return \StructType\ORSipProfile
     */
    public function setGClear(\StructType\ORFkType $gClear = null)
    {
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return \StructType\ORFkType|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @param \StructType\ORFkType $sipBandwidthModifier
     * @return \StructType\ORSipProfile
     */
    public function setSipBandwidthModifier(\StructType\ORFkType $sipBandwidthModifier = null)
    {
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return \StructType\ORFkType|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @param \StructType\ORFkType $userAgentServerHeaderInfo
     * @return \StructType\ORSipProfile
     */
    public function setUserAgentServerHeaderInfo(\StructType\ORFkType $userAgentServerHeaderInfo = null)
    {
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * @return \StructType\ORFkType|null
     */
    public function getSipNormalizationScript()
    {
        return $this->sipNormalizationScript;
    }
    /**
     * Set sipNormalizationScript value
     * @param \StructType\ORFkType $sipNormalizationScript
     * @return \StructType\ORSipProfile
     */
    public function setSipNormalizationScript(\StructType\ORFkType $sipNormalizationScript = null)
    {
        $this->sipNormalizationScript = $sipNormalizationScript;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return \StructType\ORFkType|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @param \StructType\ORFkType $dialStringInterpretation
     * @return \StructType\ORSipProfile
     */
    public function setDialStringInterpretation(\StructType\ORFkType $dialStringInterpretation = null)
    {
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return \StructType\ORFkType|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @param \StructType\ORFkType $acceptAudioCodecPreferences
     * @return \StructType\ORSipProfile
     */
    public function setAcceptAudioCodecPreferences(\StructType\ORFkType $acceptAudioCodecPreferences = null)
    {
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * @return \StructType\ORFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return $this->resourcePriorityNamespace;
    }
    /**
     * Set resourcePriorityNamespace value
     * @param \StructType\ORFkType $resourcePriorityNamespace
     * @return \StructType\ORSipProfile
     */
    public function setResourcePriorityNamespace(\StructType\ORFkType $resourcePriorityNamespace = null)
    {
        $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return \StructType\ORFkType|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @param \StructType\ORFkType $callingLineIdentification
     * @return \StructType\ORSipProfile
     */
    public function setCallingLineIdentification(\StructType\ORFkType $callingLineIdentification = null)
    {
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return \StructType\ORFkType|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @param \StructType\ORFkType $videoCallTrafficClass
     * @return \StructType\ORSipProfile
     */
    public function setVideoCallTrafficClass(\StructType\ORFkType $videoCallTrafficClass = null)
    {
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get sdpTransparency value
     * @return \StructType\ORFkType|null
     */
    public function getSdpTransparency()
    {
        return $this->sdpTransparency;
    }
    /**
     * Set sdpTransparency value
     * @param \StructType\ORFkType $sdpTransparency
     * @return \StructType\ORSipProfile
     */
    public function setSdpTransparency(\StructType\ORFkType $sdpTransparency = null)
    {
        $this->sdpTransparency = $sdpTransparency;
        return $this;
    }
    /**
     * Get sipSessionRefreshMethod value
     * @return \StructType\ORFkType|null
     */
    public function getSipSessionRefreshMethod()
    {
        return $this->sipSessionRefreshMethod;
    }
    /**
     * Set sipSessionRefreshMethod value
     * @param \StructType\ORFkType $sipSessionRefreshMethod
     * @return \StructType\ORSipProfile
     */
    public function setSipSessionRefreshMethod(\StructType\ORFkType $sipSessionRefreshMethod = null)
    {
        $this->sipSessionRefreshMethod = $sipSessionRefreshMethod;
        return $this;
    }
    /**
     * Get earlyOfferSuppVoiceCall value
     * @return \StructType\ORFkType|null
     */
    public function getEarlyOfferSuppVoiceCall()
    {
        return $this->earlyOfferSuppVoiceCall;
    }
    /**
     * Set earlyOfferSuppVoiceCall value
     * @param \StructType\ORFkType $earlyOfferSuppVoiceCall
     * @return \StructType\ORSipProfile
     */
    public function setEarlyOfferSuppVoiceCall(\StructType\ORFkType $earlyOfferSuppVoiceCall = null)
    {
        $this->earlyOfferSuppVoiceCall = $earlyOfferSuppVoiceCall;
        return $this;
    }
    /**
     * Get cucmVersionInSipHeader value
     * @return \StructType\ORFkType|null
     */
    public function getCucmVersionInSipHeader()
    {
        return $this->cucmVersionInSipHeader;
    }
    /**
     * Set cucmVersionInSipHeader value
     * @param \StructType\ORFkType $cucmVersionInSipHeader
     * @return \StructType\ORSipProfile
     */
    public function setCucmVersionInSipHeader(\StructType\ORFkType $cucmVersionInSipHeader = null)
    {
        $this->cucmVersionInSipHeader = $cucmVersionInSipHeader;
        return $this;
    }
    /**
     * Get confidentialAccessLevelHeaders value
     * @return \StructType\ORFkType|null
     */
    public function getConfidentialAccessLevelHeaders()
    {
        return $this->confidentialAccessLevelHeaders;
    }
    /**
     * Set confidentialAccessLevelHeaders value
     * @param \StructType\ORFkType $confidentialAccessLevelHeaders
     * @return \StructType\ORSipProfile
     */
    public function setConfidentialAccessLevelHeaders(\StructType\ORFkType $confidentialAccessLevelHeaders = null)
    {
        $this->confidentialAccessLevelHeaders = $confidentialAccessLevelHeaders;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\ORSipProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ORSipProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
