<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LUniversalLineTemplate StructType
 * @subpackage Structs
 */
class LUniversalLineTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The urgentPriority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $urgentPriority;
    /**
     * The lineDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lineDescription;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routePartition;
    /**
     * The voiceMailProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $voiceMailProfile;
    /**
     * The callingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingSearchSpace;
    /**
     * The alertingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alertingName;
    /**
     * The extCallControlProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $extCallControlProfile;
    /**
     * The blfPresenceGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $blfPresenceGroup;
    /**
     * The callPickupGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callPickupGroup;
    /**
     * The partyEntranceTone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partyEntranceTone;
    /**
     * The autoAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $autoAnswer;
    /**
     * The rejectAnonymousCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousCall;
    /**
     * The userHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSource;
    /**
     * The networkHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSource;
    /**
     * The aarDestinationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $aarDestinationMask;
    /**
     * The aarGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarGroup;
    /**
     * The retainDestInCallFwdHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retainDestInCallFwdHistory;
    /**
     * The forwardDestAllCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardDestAllCalls;
    /**
     * The primaryCssForwardingAllCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $primaryCssForwardingAllCalls;
    /**
     * The secondaryCssForwardingAllCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $secondaryCssForwardingAllCalls;
    /**
     * The CssActivationPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CssActivationPolicy;
    /**
     * The fwdDestExtCallsWhenNotRetrieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fwdDestExtCallsWhenNotRetrieved;
    /**
     * The cssFwdExtCallsWhenNotRetrieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cssFwdExtCallsWhenNotRetrieved;
    /**
     * The fwdDestInternalCallsWhenNotRetrieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $fwdDestInternalCallsWhenNotRetrieved;
    /**
     * The cssFwdInternalCallsWhenNotRetrieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cssFwdInternalCallsWhenNotRetrieved;
    /**
     * The parkMonitorReversionTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parkMonitorReversionTime;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $target;
    /**
     * The mlppCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mlppCss;
    /**
     * The mlppNoAnsRingDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppNoAnsRingDuration;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The holdReversionRingDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $holdReversionRingDuration;
    /**
     * The holdReversionNotificationInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $holdReversionNotificationInterval;
    /**
     * The busyIntCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $busyIntCallsDestination;
    /**
     * The busyIntCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $busyIntCallsCss;
    /**
     * The busyExtCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $busyExtCallsDestination;
    /**
     * The busyExtCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $busyExtCallsCss;
    /**
     * The noAnsIntCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noAnsIntCallsDestination;
    /**
     * The noAnsIntCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $noAnsIntCallsCss;
    /**
     * The noAnsExtCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noAnsExtCallsDestination;
    /**
     * The noAnsExtCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $noAnsExtCallsCss;
    /**
     * The noCoverageIntCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noCoverageIntCallsDestination;
    /**
     * The noCoverageIntCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $noCoverageIntCallsCss;
    /**
     * The noCoverageExtCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noCoverageExtCallsDestination;
    /**
     * The noCoverageExtCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $noCoverageExtCallsCss;
    /**
     * The unregisteredIntCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unregisteredIntCallsDestination;
    /**
     * The unregisteredIntCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $unregisteredIntCallsCss;
    /**
     * The unregisteredExtCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unregisteredExtCallsDestination;
    /**
     * The unregisteredExtCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $unregisteredExtCallsCss;
    /**
     * The ctiFailureDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ctiFailureDestination;
    /**
     * The ctiFailureCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $ctiFailureCss;
    /**
     * The callControlAgentProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callControlAgentProfile;
    /**
     * The enterpriseAltNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\E164AltNum
     */
    public $e164AltNum;
    /**
     * The advertisedFailoverNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $advertisedFailoverNumber;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LUniversalLineTemplate
     * @uses LUniversalLineTemplate::setName()
     * @uses LUniversalLineTemplate::setUrgentPriority()
     * @uses LUniversalLineTemplate::setLineDescription()
     * @uses LUniversalLineTemplate::setRoutePartition()
     * @uses LUniversalLineTemplate::setVoiceMailProfile()
     * @uses LUniversalLineTemplate::setCallingSearchSpace()
     * @uses LUniversalLineTemplate::setAlertingName()
     * @uses LUniversalLineTemplate::setExtCallControlProfile()
     * @uses LUniversalLineTemplate::setBlfPresenceGroup()
     * @uses LUniversalLineTemplate::setCallPickupGroup()
     * @uses LUniversalLineTemplate::setPartyEntranceTone()
     * @uses LUniversalLineTemplate::setAutoAnswer()
     * @uses LUniversalLineTemplate::setRejectAnonymousCall()
     * @uses LUniversalLineTemplate::setUserHoldMohAudioSource()
     * @uses LUniversalLineTemplate::setNetworkHoldMohAudioSource()
     * @uses LUniversalLineTemplate::setAarDestinationMask()
     * @uses LUniversalLineTemplate::setAarGroup()
     * @uses LUniversalLineTemplate::setRetainDestInCallFwdHistory()
     * @uses LUniversalLineTemplate::setForwardDestAllCalls()
     * @uses LUniversalLineTemplate::setPrimaryCssForwardingAllCalls()
     * @uses LUniversalLineTemplate::setSecondaryCssForwardingAllCalls()
     * @uses LUniversalLineTemplate::setCssActivationPolicy()
     * @uses LUniversalLineTemplate::setFwdDestExtCallsWhenNotRetrieved()
     * @uses LUniversalLineTemplate::setCssFwdExtCallsWhenNotRetrieved()
     * @uses LUniversalLineTemplate::setFwdDestInternalCallsWhenNotRetrieved()
     * @uses LUniversalLineTemplate::setCssFwdInternalCallsWhenNotRetrieved()
     * @uses LUniversalLineTemplate::setParkMonitorReversionTime()
     * @uses LUniversalLineTemplate::setTarget()
     * @uses LUniversalLineTemplate::setMlppCss()
     * @uses LUniversalLineTemplate::setMlppNoAnsRingDuration()
     * @uses LUniversalLineTemplate::setConfidentialAccess()
     * @uses LUniversalLineTemplate::setHoldReversionRingDuration()
     * @uses LUniversalLineTemplate::setHoldReversionNotificationInterval()
     * @uses LUniversalLineTemplate::setBusyIntCallsDestination()
     * @uses LUniversalLineTemplate::setBusyIntCallsCss()
     * @uses LUniversalLineTemplate::setBusyExtCallsDestination()
     * @uses LUniversalLineTemplate::setBusyExtCallsCss()
     * @uses LUniversalLineTemplate::setNoAnsIntCallsDestination()
     * @uses LUniversalLineTemplate::setNoAnsIntCallsCss()
     * @uses LUniversalLineTemplate::setNoAnsExtCallsDestination()
     * @uses LUniversalLineTemplate::setNoAnsExtCallsCss()
     * @uses LUniversalLineTemplate::setNoCoverageIntCallsDestination()
     * @uses LUniversalLineTemplate::setNoCoverageIntCallsCss()
     * @uses LUniversalLineTemplate::setNoCoverageExtCallsDestination()
     * @uses LUniversalLineTemplate::setNoCoverageExtCallsCss()
     * @uses LUniversalLineTemplate::setUnregisteredIntCallsDestination()
     * @uses LUniversalLineTemplate::setUnregisteredIntCallsCss()
     * @uses LUniversalLineTemplate::setUnregisteredExtCallsDestination()
     * @uses LUniversalLineTemplate::setUnregisteredExtCallsCss()
     * @uses LUniversalLineTemplate::setCtiFailureDestination()
     * @uses LUniversalLineTemplate::setCtiFailureCss()
     * @uses LUniversalLineTemplate::setCallControlAgentProfile()
     * @uses LUniversalLineTemplate::setEnterpriseAltNum()
     * @uses LUniversalLineTemplate::setE164AltNum()
     * @uses LUniversalLineTemplate::setAdvertisedFailoverNumber()
     * @uses LUniversalLineTemplate::setUuid()
     * @param string $name
     * @param string $urgentPriority
     * @param string $lineDescription
     * @param \StructType\XFkType $routePartition
     * @param \StructType\XFkType $voiceMailProfile
     * @param \StructType\XFkType $callingSearchSpace
     * @param string $alertingName
     * @param \StructType\XFkType $extCallControlProfile
     * @param \StructType\XFkType $blfPresenceGroup
     * @param \StructType\XFkType $callPickupGroup
     * @param string $partyEntranceTone
     * @param string $autoAnswer
     * @param string $rejectAnonymousCall
     * @param string $userHoldMohAudioSource
     * @param string $networkHoldMohAudioSource
     * @param string $aarDestinationMask
     * @param \StructType\XFkType $aarGroup
     * @param string $retainDestInCallFwdHistory
     * @param string $forwardDestAllCalls
     * @param \StructType\XFkType $primaryCssForwardingAllCalls
     * @param \StructType\XFkType $secondaryCssForwardingAllCalls
     * @param string $cssActivationPolicy
     * @param string $fwdDestExtCallsWhenNotRetrieved
     * @param \StructType\XFkType $cssFwdExtCallsWhenNotRetrieved
     * @param string $fwdDestInternalCallsWhenNotRetrieved
     * @param \StructType\XFkType $cssFwdInternalCallsWhenNotRetrieved
     * @param string $parkMonitorReversionTime
     * @param string $target
     * @param \StructType\XFkType $mlppCss
     * @param string $mlppNoAnsRingDuration
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param string $holdReversionRingDuration
     * @param string $holdReversionNotificationInterval
     * @param string $busyIntCallsDestination
     * @param \StructType\XFkType $busyIntCallsCss
     * @param string $busyExtCallsDestination
     * @param \StructType\XFkType $busyExtCallsCss
     * @param string $noAnsIntCallsDestination
     * @param \StructType\XFkType $noAnsIntCallsCss
     * @param string $noAnsExtCallsDestination
     * @param \StructType\XFkType $noAnsExtCallsCss
     * @param string $noCoverageIntCallsDestination
     * @param \StructType\XFkType $noCoverageIntCallsCss
     * @param string $noCoverageExtCallsDestination
     * @param \StructType\XFkType $noCoverageExtCallsCss
     * @param string $unregisteredIntCallsDestination
     * @param \StructType\XFkType $unregisteredIntCallsCss
     * @param string $unregisteredExtCallsDestination
     * @param \StructType\XFkType $unregisteredExtCallsCss
     * @param string $ctiFailureDestination
     * @param \StructType\XFkType $ctiFailureCss
     * @param string $callControlAgentProfile
     * @param \StructType\EnterpriseAltNum $enterpriseAltNum
     * @param \StructType\E164AltNum $e164AltNum
     * @param string $advertisedFailoverNumber
     * @param string $uuid
     */
    public function __construct($name = null, $urgentPriority = null, $lineDescription = null, \StructType\XFkType $routePartition = null, \StructType\XFkType $voiceMailProfile = null, \StructType\XFkType $callingSearchSpace = null, $alertingName = null, \StructType\XFkType $extCallControlProfile = null, \StructType\XFkType $blfPresenceGroup = null, \StructType\XFkType $callPickupGroup = null, $partyEntranceTone = null, $autoAnswer = null, $rejectAnonymousCall = null, $userHoldMohAudioSource = null, $networkHoldMohAudioSource = null, $aarDestinationMask = null, \StructType\XFkType $aarGroup = null, $retainDestInCallFwdHistory = null, $forwardDestAllCalls = null, \StructType\XFkType $primaryCssForwardingAllCalls = null, \StructType\XFkType $secondaryCssForwardingAllCalls = null, $cssActivationPolicy = null, $fwdDestExtCallsWhenNotRetrieved = null, \StructType\XFkType $cssFwdExtCallsWhenNotRetrieved = null, $fwdDestInternalCallsWhenNotRetrieved = null, \StructType\XFkType $cssFwdInternalCallsWhenNotRetrieved = null, $parkMonitorReversionTime = null, $target = null, \StructType\XFkType $mlppCss = null, $mlppNoAnsRingDuration = null, \StructType\ConfidentialAccess $confidentialAccess = null, $holdReversionRingDuration = null, $holdReversionNotificationInterval = null, $busyIntCallsDestination = null, \StructType\XFkType $busyIntCallsCss = null, $busyExtCallsDestination = null, \StructType\XFkType $busyExtCallsCss = null, $noAnsIntCallsDestination = null, \StructType\XFkType $noAnsIntCallsCss = null, $noAnsExtCallsDestination = null, \StructType\XFkType $noAnsExtCallsCss = null, $noCoverageIntCallsDestination = null, \StructType\XFkType $noCoverageIntCallsCss = null, $noCoverageExtCallsDestination = null, \StructType\XFkType $noCoverageExtCallsCss = null, $unregisteredIntCallsDestination = null, \StructType\XFkType $unregisteredIntCallsCss = null, $unregisteredExtCallsDestination = null, \StructType\XFkType $unregisteredExtCallsCss = null, $ctiFailureDestination = null, \StructType\XFkType $ctiFailureCss = null, $callControlAgentProfile = null, \StructType\EnterpriseAltNum $enterpriseAltNum = null, \StructType\E164AltNum $e164AltNum = null, $advertisedFailoverNumber = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setUrgentPriority($urgentPriority)
            ->setLineDescription($lineDescription)
            ->setRoutePartition($routePartition)
            ->setVoiceMailProfile($voiceMailProfile)
            ->setCallingSearchSpace($callingSearchSpace)
            ->setAlertingName($alertingName)
            ->setExtCallControlProfile($extCallControlProfile)
            ->setBlfPresenceGroup($blfPresenceGroup)
            ->setCallPickupGroup($callPickupGroup)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setAutoAnswer($autoAnswer)
            ->setRejectAnonymousCall($rejectAnonymousCall)
            ->setUserHoldMohAudioSource($userHoldMohAudioSource)
            ->setNetworkHoldMohAudioSource($networkHoldMohAudioSource)
            ->setAarDestinationMask($aarDestinationMask)
            ->setAarGroup($aarGroup)
            ->setRetainDestInCallFwdHistory($retainDestInCallFwdHistory)
            ->setForwardDestAllCalls($forwardDestAllCalls)
            ->setPrimaryCssForwardingAllCalls($primaryCssForwardingAllCalls)
            ->setSecondaryCssForwardingAllCalls($secondaryCssForwardingAllCalls)
            ->setCssActivationPolicy($cssActivationPolicy)
            ->setFwdDestExtCallsWhenNotRetrieved($fwdDestExtCallsWhenNotRetrieved)
            ->setCssFwdExtCallsWhenNotRetrieved($cssFwdExtCallsWhenNotRetrieved)
            ->setFwdDestInternalCallsWhenNotRetrieved($fwdDestInternalCallsWhenNotRetrieved)
            ->setCssFwdInternalCallsWhenNotRetrieved($cssFwdInternalCallsWhenNotRetrieved)
            ->setParkMonitorReversionTime($parkMonitorReversionTime)
            ->setTarget($target)
            ->setMlppCss($mlppCss)
            ->setMlppNoAnsRingDuration($mlppNoAnsRingDuration)
            ->setConfidentialAccess($confidentialAccess)
            ->setHoldReversionRingDuration($holdReversionRingDuration)
            ->setHoldReversionNotificationInterval($holdReversionNotificationInterval)
            ->setBusyIntCallsDestination($busyIntCallsDestination)
            ->setBusyIntCallsCss($busyIntCallsCss)
            ->setBusyExtCallsDestination($busyExtCallsDestination)
            ->setBusyExtCallsCss($busyExtCallsCss)
            ->setNoAnsIntCallsDestination($noAnsIntCallsDestination)
            ->setNoAnsIntCallsCss($noAnsIntCallsCss)
            ->setNoAnsExtCallsDestination($noAnsExtCallsDestination)
            ->setNoAnsExtCallsCss($noAnsExtCallsCss)
            ->setNoCoverageIntCallsDestination($noCoverageIntCallsDestination)
            ->setNoCoverageIntCallsCss($noCoverageIntCallsCss)
            ->setNoCoverageExtCallsDestination($noCoverageExtCallsDestination)
            ->setNoCoverageExtCallsCss($noCoverageExtCallsCss)
            ->setUnregisteredIntCallsDestination($unregisteredIntCallsDestination)
            ->setUnregisteredIntCallsCss($unregisteredIntCallsCss)
            ->setUnregisteredExtCallsDestination($unregisteredExtCallsDestination)
            ->setUnregisteredExtCallsCss($unregisteredExtCallsCss)
            ->setCtiFailureDestination($ctiFailureDestination)
            ->setCtiFailureCss($ctiFailureCss)
            ->setCallControlAgentProfile($callControlAgentProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setAdvertisedFailoverNumber($advertisedFailoverNumber)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LUniversalLineTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get urgentPriority value
     * @return string|null
     */
    public function getUrgentPriority()
    {
        return $this->urgentPriority;
    }
    /**
     * Set urgentPriority value
     * @param string $urgentPriority
     * @return \StructType\LUniversalLineTemplate
     */
    public function setUrgentPriority($urgentPriority = null)
    {
        // validation for constraint: pattern
        if (is_scalar($urgentPriority) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $urgentPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($urgentPriority, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($urgentPriority) && !is_string($urgentPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urgentPriority)), __LINE__);
        }
        $this->urgentPriority = $urgentPriority;
        return $this;
    }
    /**
     * Get lineDescription value
     * @return string|null
     */
    public function getLineDescription()
    {
        return $this->lineDescription;
    }
    /**
     * Set lineDescription value
     * @param string $lineDescription
     * @return \StructType\LUniversalLineTemplate
     */
    public function setLineDescription($lineDescription = null)
    {
        // validation for constraint: string
        if (!is_null($lineDescription) && !is_string($lineDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineDescription)), __LINE__);
        }
        $this->lineDescription = $lineDescription;
        return $this;
    }
    /**
     * Get routePartition value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param \StructType\XFkType $routePartition
     * @return \StructType\LUniversalLineTemplate
     */
    public function setRoutePartition(\StructType\XFkType $routePartition = null)
    {
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get voiceMailProfile value
     * @return \StructType\XFkType|null
     */
    public function getVoiceMailProfile()
    {
        return $this->voiceMailProfile;
    }
    /**
     * Set voiceMailProfile value
     * @param \StructType\XFkType $voiceMailProfile
     * @return \StructType\LUniversalLineTemplate
     */
    public function setVoiceMailProfile(\StructType\XFkType $voiceMailProfile = null)
    {
        $this->voiceMailProfile = $voiceMailProfile;
        return $this;
    }
    /**
     * Get callingSearchSpace value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpace()
    {
        return $this->callingSearchSpace;
    }
    /**
     * Set callingSearchSpace value
     * @param \StructType\XFkType $callingSearchSpace
     * @return \StructType\LUniversalLineTemplate
     */
    public function setCallingSearchSpace(\StructType\XFkType $callingSearchSpace = null)
    {
        $this->callingSearchSpace = $callingSearchSpace;
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \StructType\LUniversalLineTemplate
     */
    public function setAlertingName($alertingName = null)
    {
        // validation for constraint: string
        if (!is_null($alertingName) && !is_string($alertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertingName)), __LINE__);
        }
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get extCallControlProfile value
     * @return \StructType\XFkType|null
     */
    public function getExtCallControlProfile()
    {
        return $this->extCallControlProfile;
    }
    /**
     * Set extCallControlProfile value
     * @param \StructType\XFkType $extCallControlProfile
     * @return \StructType\LUniversalLineTemplate
     */
    public function setExtCallControlProfile(\StructType\XFkType $extCallControlProfile = null)
    {
        $this->extCallControlProfile = $extCallControlProfile;
        return $this;
    }
    /**
     * Get blfPresenceGroup value
     * @return \StructType\XFkType|null
     */
    public function getBlfPresenceGroup()
    {
        return $this->blfPresenceGroup;
    }
    /**
     * Set blfPresenceGroup value
     * @param \StructType\XFkType $blfPresenceGroup
     * @return \StructType\LUniversalLineTemplate
     */
    public function setBlfPresenceGroup(\StructType\XFkType $blfPresenceGroup = null)
    {
        $this->blfPresenceGroup = $blfPresenceGroup;
        return $this;
    }
    /**
     * Get callPickupGroup value
     * @return \StructType\XFkType|null
     */
    public function getCallPickupGroup()
    {
        return $this->callPickupGroup;
    }
    /**
     * Set callPickupGroup value
     * @param \StructType\XFkType $callPickupGroup
     * @return \StructType\LUniversalLineTemplate
     */
    public function setCallPickupGroup(\StructType\XFkType $callPickupGroup = null)
    {
        $this->callPickupGroup = $callPickupGroup;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return string|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partyEntranceTone
     * @return \StructType\LUniversalLineTemplate
     */
    public function setPartyEntranceTone($partyEntranceTone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($partyEntranceTone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $partyEntranceTone, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return string|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @uses \EnumType\XAutoAnswer::valueIsValid()
     * @uses \EnumType\XAutoAnswer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoAnswer
     * @return \StructType\LUniversalLineTemplate
     */
    public function setAutoAnswer($autoAnswer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAutoAnswer::valueIsValid($autoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $autoAnswer, implode(', ', \EnumType\XAutoAnswer::getValidValues())), __LINE__);
        }
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get rejectAnonymousCall value
     * @return string|null
     */
    public function getRejectAnonymousCall()
    {
        return $this->rejectAnonymousCall;
    }
    /**
     * Set rejectAnonymousCall value
     * @param string $rejectAnonymousCall
     * @return \StructType\LUniversalLineTemplate
     */
    public function setRejectAnonymousCall($rejectAnonymousCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rejectAnonymousCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rejectAnonymousCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rejectAnonymousCall) && !is_string($rejectAnonymousCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rejectAnonymousCall)), __LINE__);
        }
        $this->rejectAnonymousCall = $rejectAnonymousCall;
        return $this;
    }
    /**
     * Get userHoldMohAudioSource value
     * @return string|null
     */
    public function getUserHoldMohAudioSource()
    {
        return $this->userHoldMohAudioSource;
    }
    /**
     * Set userHoldMohAudioSource value
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSource
     * @return \StructType\LUniversalLineTemplate
     */
    public function setUserHoldMohAudioSource($userHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSource, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSource = $userHoldMohAudioSource;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSource value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSource()
    {
        return $this->networkHoldMohAudioSource;
    }
    /**
     * Set networkHoldMohAudioSource value
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSource
     * @return \StructType\LUniversalLineTemplate
     */
    public function setNetworkHoldMohAudioSource($networkHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSource, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSource = $networkHoldMohAudioSource;
        return $this;
    }
    /**
     * Get aarDestinationMask value
     * @return string|null
     */
    public function getAarDestinationMask()
    {
        return $this->aarDestinationMask;
    }
    /**
     * Set aarDestinationMask value
     * @param string $aarDestinationMask
     * @return \StructType\LUniversalLineTemplate
     */
    public function setAarDestinationMask($aarDestinationMask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aarDestinationMask) && strlen($aarDestinationMask) > 128) || (is_array($aarDestinationMask) && count($aarDestinationMask) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($aarDestinationMask) ? strlen($aarDestinationMask) : count($aarDestinationMask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aarDestinationMask) && !is_string($aarDestinationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aarDestinationMask)), __LINE__);
        }
        $this->aarDestinationMask = $aarDestinationMask;
        return $this;
    }
    /**
     * Get aarGroup value
     * @return \StructType\XFkType|null
     */
    public function getAarGroup()
    {
        return $this->aarGroup;
    }
    /**
     * Set aarGroup value
     * @param \StructType\XFkType $aarGroup
     * @return \StructType\LUniversalLineTemplate
     */
    public function setAarGroup(\StructType\XFkType $aarGroup = null)
    {
        $this->aarGroup = $aarGroup;
        return $this;
    }
    /**
     * Get retainDestInCallFwdHistory value
     * @return string|null
     */
    public function getRetainDestInCallFwdHistory()
    {
        return $this->retainDestInCallFwdHistory;
    }
    /**
     * Set retainDestInCallFwdHistory value
     * @param string $retainDestInCallFwdHistory
     * @return \StructType\LUniversalLineTemplate
     */
    public function setRetainDestInCallFwdHistory($retainDestInCallFwdHistory = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retainDestInCallFwdHistory) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retainDestInCallFwdHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retainDestInCallFwdHistory, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retainDestInCallFwdHistory) && !is_string($retainDestInCallFwdHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retainDestInCallFwdHistory)), __LINE__);
        }
        $this->retainDestInCallFwdHistory = $retainDestInCallFwdHistory;
        return $this;
    }
    /**
     * Get forwardDestAllCalls value
     * @return string|null
     */
    public function getForwardDestAllCalls()
    {
        return $this->forwardDestAllCalls;
    }
    /**
     * Set forwardDestAllCalls value
     * @param string $forwardDestAllCalls
     * @return \StructType\LUniversalLineTemplate
     */
    public function setForwardDestAllCalls($forwardDestAllCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($forwardDestAllCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $forwardDestAllCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($forwardDestAllCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($forwardDestAllCalls) && !is_string($forwardDestAllCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardDestAllCalls)), __LINE__);
        }
        $this->forwardDestAllCalls = $forwardDestAllCalls;
        return $this;
    }
    /**
     * Get primaryCssForwardingAllCalls value
     * @return \StructType\XFkType|null
     */
    public function getPrimaryCssForwardingAllCalls()
    {
        return $this->primaryCssForwardingAllCalls;
    }
    /**
     * Set primaryCssForwardingAllCalls value
     * @param \StructType\XFkType $primaryCssForwardingAllCalls
     * @return \StructType\LUniversalLineTemplate
     */
    public function setPrimaryCssForwardingAllCalls(\StructType\XFkType $primaryCssForwardingAllCalls = null)
    {
        $this->primaryCssForwardingAllCalls = $primaryCssForwardingAllCalls;
        return $this;
    }
    /**
     * Get secondaryCssForwardingAllCalls value
     * @return \StructType\XFkType|null
     */
    public function getSecondaryCssForwardingAllCalls()
    {
        return $this->secondaryCssForwardingAllCalls;
    }
    /**
     * Set secondaryCssForwardingAllCalls value
     * @param \StructType\XFkType $secondaryCssForwardingAllCalls
     * @return \StructType\LUniversalLineTemplate
     */
    public function setSecondaryCssForwardingAllCalls(\StructType\XFkType $secondaryCssForwardingAllCalls = null)
    {
        $this->secondaryCssForwardingAllCalls = $secondaryCssForwardingAllCalls;
        return $this;
    }
    /**
     * Get CssActivationPolicy value
     * @return string|null
     */
    public function getCssActivationPolicy()
    {
        return $this->CssActivationPolicy;
    }
    /**
     * Set CssActivationPolicy value
     * @uses \EnumType\XCFACSSActivationPolicy::valueIsValid()
     * @uses \EnumType\XCFACSSActivationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cssActivationPolicy
     * @return \StructType\LUniversalLineTemplate
     */
    public function setCssActivationPolicy($cssActivationPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCFACSSActivationPolicy::valueIsValid($cssActivationPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cssActivationPolicy, implode(', ', \EnumType\XCFACSSActivationPolicy::getValidValues())), __LINE__);
        }
        $this->CssActivationPolicy = $cssActivationPolicy;
        return $this;
    }
    /**
     * Get fwdDestExtCallsWhenNotRetrieved value
     * @return string|null
     */
    public function getFwdDestExtCallsWhenNotRetrieved()
    {
        return $this->fwdDestExtCallsWhenNotRetrieved;
    }
    /**
     * Set fwdDestExtCallsWhenNotRetrieved value
     * @param string $fwdDestExtCallsWhenNotRetrieved
     * @return \StructType\LUniversalLineTemplate
     */
    public function setFwdDestExtCallsWhenNotRetrieved($fwdDestExtCallsWhenNotRetrieved = null)
    {
        // validation for constraint: string
        if (!is_null($fwdDestExtCallsWhenNotRetrieved) && !is_string($fwdDestExtCallsWhenNotRetrieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fwdDestExtCallsWhenNotRetrieved)), __LINE__);
        }
        $this->fwdDestExtCallsWhenNotRetrieved = $fwdDestExtCallsWhenNotRetrieved;
        return $this;
    }
    /**
     * Get cssFwdExtCallsWhenNotRetrieved value
     * @return \StructType\XFkType|null
     */
    public function getCssFwdExtCallsWhenNotRetrieved()
    {
        return $this->cssFwdExtCallsWhenNotRetrieved;
    }
    /**
     * Set cssFwdExtCallsWhenNotRetrieved value
     * @param \StructType\XFkType $cssFwdExtCallsWhenNotRetrieved
     * @return \StructType\LUniversalLineTemplate
     */
    public function setCssFwdExtCallsWhenNotRetrieved(\StructType\XFkType $cssFwdExtCallsWhenNotRetrieved = null)
    {
        $this->cssFwdExtCallsWhenNotRetrieved = $cssFwdExtCallsWhenNotRetrieved;
        return $this;
    }
    /**
     * Get fwdDestInternalCallsWhenNotRetrieved value
     * @return string|null
     */
    public function getFwdDestInternalCallsWhenNotRetrieved()
    {
        return $this->fwdDestInternalCallsWhenNotRetrieved;
    }
    /**
     * Set fwdDestInternalCallsWhenNotRetrieved value
     * @param string $fwdDestInternalCallsWhenNotRetrieved
     * @return \StructType\LUniversalLineTemplate
     */
    public function setFwdDestInternalCallsWhenNotRetrieved($fwdDestInternalCallsWhenNotRetrieved = null)
    {
        // validation for constraint: pattern
        if (is_scalar($fwdDestInternalCallsWhenNotRetrieved) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $fwdDestInternalCallsWhenNotRetrieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($fwdDestInternalCallsWhenNotRetrieved, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fwdDestInternalCallsWhenNotRetrieved) && !is_string($fwdDestInternalCallsWhenNotRetrieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fwdDestInternalCallsWhenNotRetrieved)), __LINE__);
        }
        $this->fwdDestInternalCallsWhenNotRetrieved = $fwdDestInternalCallsWhenNotRetrieved;
        return $this;
    }
    /**
     * Get cssFwdInternalCallsWhenNotRetrieved value
     * @return \StructType\XFkType|null
     */
    public function getCssFwdInternalCallsWhenNotRetrieved()
    {
        return $this->cssFwdInternalCallsWhenNotRetrieved;
    }
    /**
     * Set cssFwdInternalCallsWhenNotRetrieved value
     * @param \StructType\XFkType $cssFwdInternalCallsWhenNotRetrieved
     * @return \StructType\LUniversalLineTemplate
     */
    public function setCssFwdInternalCallsWhenNotRetrieved(\StructType\XFkType $cssFwdInternalCallsWhenNotRetrieved = null)
    {
        $this->cssFwdInternalCallsWhenNotRetrieved = $cssFwdInternalCallsWhenNotRetrieved;
        return $this;
    }
    /**
     * Get parkMonitorReversionTime value
     * @return string|null
     */
    public function getParkMonitorReversionTime()
    {
        return $this->parkMonitorReversionTime;
    }
    /**
     * Set parkMonitorReversionTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parkMonitorReversionTime
     * @return \StructType\LUniversalLineTemplate
     */
    public function setParkMonitorReversionTime($parkMonitorReversionTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($parkMonitorReversionTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $parkMonitorReversionTime, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->parkMonitorReversionTime = $parkMonitorReversionTime;
        return $this;
    }
    /**
     * Get target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param string $target
     * @return \StructType\LUniversalLineTemplate
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Get mlppCss value
     * @return \StructType\XFkType|null
     */
    public function getMlppCss()
    {
        return $this->mlppCss;
    }
    /**
     * Set mlppCss value
     * @param \StructType\XFkType $mlppCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setMlppCss(\StructType\XFkType $mlppCss = null)
    {
        $this->mlppCss = $mlppCss;
        return $this;
    }
    /**
     * Get mlppNoAnsRingDuration value
     * @return string|null
     */
    public function getMlppNoAnsRingDuration()
    {
        return $this->mlppNoAnsRingDuration;
    }
    /**
     * Set mlppNoAnsRingDuration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppNoAnsRingDuration
     * @return \StructType\LUniversalLineTemplate
     */
    public function setMlppNoAnsRingDuration($mlppNoAnsRingDuration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($mlppNoAnsRingDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppNoAnsRingDuration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->mlppNoAnsRingDuration = $mlppNoAnsRingDuration;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\LUniversalLineTemplate
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get holdReversionRingDuration value
     * @return string|null
     */
    public function getHoldReversionRingDuration()
    {
        return $this->holdReversionRingDuration;
    }
    /**
     * Set holdReversionRingDuration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $holdReversionRingDuration
     * @return \StructType\LUniversalLineTemplate
     */
    public function setHoldReversionRingDuration($holdReversionRingDuration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($holdReversionRingDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $holdReversionRingDuration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->holdReversionRingDuration = $holdReversionRingDuration;
        return $this;
    }
    /**
     * Get holdReversionNotificationInterval value
     * @return string|null
     */
    public function getHoldReversionNotificationInterval()
    {
        return $this->holdReversionNotificationInterval;
    }
    /**
     * Set holdReversionNotificationInterval value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $holdReversionNotificationInterval
     * @return \StructType\LUniversalLineTemplate
     */
    public function setHoldReversionNotificationInterval($holdReversionNotificationInterval = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($holdReversionNotificationInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $holdReversionNotificationInterval, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->holdReversionNotificationInterval = $holdReversionNotificationInterval;
        return $this;
    }
    /**
     * Get busyIntCallsDestination value
     * @return string|null
     */
    public function getBusyIntCallsDestination()
    {
        return $this->busyIntCallsDestination;
    }
    /**
     * Set busyIntCallsDestination value
     * @param string $busyIntCallsDestination
     * @return \StructType\LUniversalLineTemplate
     */
    public function setBusyIntCallsDestination($busyIntCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($busyIntCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $busyIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($busyIntCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($busyIntCallsDestination) && !is_string($busyIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busyIntCallsDestination)), __LINE__);
        }
        $this->busyIntCallsDestination = $busyIntCallsDestination;
        return $this;
    }
    /**
     * Get busyIntCallsCss value
     * @return \StructType\XFkType|null
     */
    public function getBusyIntCallsCss()
    {
        return $this->busyIntCallsCss;
    }
    /**
     * Set busyIntCallsCss value
     * @param \StructType\XFkType $busyIntCallsCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setBusyIntCallsCss(\StructType\XFkType $busyIntCallsCss = null)
    {
        $this->busyIntCallsCss = $busyIntCallsCss;
        return $this;
    }
    /**
     * Get busyExtCallsDestination value
     * @return string|null
     */
    public function getBusyExtCallsDestination()
    {
        return $this->busyExtCallsDestination;
    }
    /**
     * Set busyExtCallsDestination value
     * @param string $busyExtCallsDestination
     * @return \StructType\LUniversalLineTemplate
     */
    public function setBusyExtCallsDestination($busyExtCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($busyExtCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $busyExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($busyExtCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($busyExtCallsDestination) && !is_string($busyExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busyExtCallsDestination)), __LINE__);
        }
        $this->busyExtCallsDestination = $busyExtCallsDestination;
        return $this;
    }
    /**
     * Get busyExtCallsCss value
     * @return \StructType\XFkType|null
     */
    public function getBusyExtCallsCss()
    {
        return $this->busyExtCallsCss;
    }
    /**
     * Set busyExtCallsCss value
     * @param \StructType\XFkType $busyExtCallsCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setBusyExtCallsCss(\StructType\XFkType $busyExtCallsCss = null)
    {
        $this->busyExtCallsCss = $busyExtCallsCss;
        return $this;
    }
    /**
     * Get noAnsIntCallsDestination value
     * @return string|null
     */
    public function getNoAnsIntCallsDestination()
    {
        return $this->noAnsIntCallsDestination;
    }
    /**
     * Set noAnsIntCallsDestination value
     * @param string $noAnsIntCallsDestination
     * @return \StructType\LUniversalLineTemplate
     */
    public function setNoAnsIntCallsDestination($noAnsIntCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($noAnsIntCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $noAnsIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($noAnsIntCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noAnsIntCallsDestination) && !is_string($noAnsIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noAnsIntCallsDestination)), __LINE__);
        }
        $this->noAnsIntCallsDestination = $noAnsIntCallsDestination;
        return $this;
    }
    /**
     * Get noAnsIntCallsCss value
     * @return \StructType\XFkType|null
     */
    public function getNoAnsIntCallsCss()
    {
        return $this->noAnsIntCallsCss;
    }
    /**
     * Set noAnsIntCallsCss value
     * @param \StructType\XFkType $noAnsIntCallsCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setNoAnsIntCallsCss(\StructType\XFkType $noAnsIntCallsCss = null)
    {
        $this->noAnsIntCallsCss = $noAnsIntCallsCss;
        return $this;
    }
    /**
     * Get noAnsExtCallsDestination value
     * @return string|null
     */
    public function getNoAnsExtCallsDestination()
    {
        return $this->noAnsExtCallsDestination;
    }
    /**
     * Set noAnsExtCallsDestination value
     * @param string $noAnsExtCallsDestination
     * @return \StructType\LUniversalLineTemplate
     */
    public function setNoAnsExtCallsDestination($noAnsExtCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($noAnsExtCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $noAnsExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($noAnsExtCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noAnsExtCallsDestination) && !is_string($noAnsExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noAnsExtCallsDestination)), __LINE__);
        }
        $this->noAnsExtCallsDestination = $noAnsExtCallsDestination;
        return $this;
    }
    /**
     * Get noAnsExtCallsCss value
     * @return \StructType\XFkType|null
     */
    public function getNoAnsExtCallsCss()
    {
        return $this->noAnsExtCallsCss;
    }
    /**
     * Set noAnsExtCallsCss value
     * @param \StructType\XFkType $noAnsExtCallsCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setNoAnsExtCallsCss(\StructType\XFkType $noAnsExtCallsCss = null)
    {
        $this->noAnsExtCallsCss = $noAnsExtCallsCss;
        return $this;
    }
    /**
     * Get noCoverageIntCallsDestination value
     * @return string|null
     */
    public function getNoCoverageIntCallsDestination()
    {
        return $this->noCoverageIntCallsDestination;
    }
    /**
     * Set noCoverageIntCallsDestination value
     * @param string $noCoverageIntCallsDestination
     * @return \StructType\LUniversalLineTemplate
     */
    public function setNoCoverageIntCallsDestination($noCoverageIntCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($noCoverageIntCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $noCoverageIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($noCoverageIntCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noCoverageIntCallsDestination) && !is_string($noCoverageIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noCoverageIntCallsDestination)), __LINE__);
        }
        $this->noCoverageIntCallsDestination = $noCoverageIntCallsDestination;
        return $this;
    }
    /**
     * Get noCoverageIntCallsCss value
     * @return \StructType\XFkType|null
     */
    public function getNoCoverageIntCallsCss()
    {
        return $this->noCoverageIntCallsCss;
    }
    /**
     * Set noCoverageIntCallsCss value
     * @param \StructType\XFkType $noCoverageIntCallsCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setNoCoverageIntCallsCss(\StructType\XFkType $noCoverageIntCallsCss = null)
    {
        $this->noCoverageIntCallsCss = $noCoverageIntCallsCss;
        return $this;
    }
    /**
     * Get noCoverageExtCallsDestination value
     * @return string|null
     */
    public function getNoCoverageExtCallsDestination()
    {
        return $this->noCoverageExtCallsDestination;
    }
    /**
     * Set noCoverageExtCallsDestination value
     * @param string $noCoverageExtCallsDestination
     * @return \StructType\LUniversalLineTemplate
     */
    public function setNoCoverageExtCallsDestination($noCoverageExtCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($noCoverageExtCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $noCoverageExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($noCoverageExtCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noCoverageExtCallsDestination) && !is_string($noCoverageExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noCoverageExtCallsDestination)), __LINE__);
        }
        $this->noCoverageExtCallsDestination = $noCoverageExtCallsDestination;
        return $this;
    }
    /**
     * Get noCoverageExtCallsCss value
     * @return \StructType\XFkType|null
     */
    public function getNoCoverageExtCallsCss()
    {
        return $this->noCoverageExtCallsCss;
    }
    /**
     * Set noCoverageExtCallsCss value
     * @param \StructType\XFkType $noCoverageExtCallsCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setNoCoverageExtCallsCss(\StructType\XFkType $noCoverageExtCallsCss = null)
    {
        $this->noCoverageExtCallsCss = $noCoverageExtCallsCss;
        return $this;
    }
    /**
     * Get unregisteredIntCallsDestination value
     * @return string|null
     */
    public function getUnregisteredIntCallsDestination()
    {
        return $this->unregisteredIntCallsDestination;
    }
    /**
     * Set unregisteredIntCallsDestination value
     * @param string $unregisteredIntCallsDestination
     * @return \StructType\LUniversalLineTemplate
     */
    public function setUnregisteredIntCallsDestination($unregisteredIntCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unregisteredIntCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unregisteredIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unregisteredIntCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unregisteredIntCallsDestination) && !is_string($unregisteredIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unregisteredIntCallsDestination)), __LINE__);
        }
        $this->unregisteredIntCallsDestination = $unregisteredIntCallsDestination;
        return $this;
    }
    /**
     * Get unregisteredIntCallsCss value
     * @return \StructType\XFkType|null
     */
    public function getUnregisteredIntCallsCss()
    {
        return $this->unregisteredIntCallsCss;
    }
    /**
     * Set unregisteredIntCallsCss value
     * @param \StructType\XFkType $unregisteredIntCallsCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setUnregisteredIntCallsCss(\StructType\XFkType $unregisteredIntCallsCss = null)
    {
        $this->unregisteredIntCallsCss = $unregisteredIntCallsCss;
        return $this;
    }
    /**
     * Get unregisteredExtCallsDestination value
     * @return string|null
     */
    public function getUnregisteredExtCallsDestination()
    {
        return $this->unregisteredExtCallsDestination;
    }
    /**
     * Set unregisteredExtCallsDestination value
     * @param string $unregisteredExtCallsDestination
     * @return \StructType\LUniversalLineTemplate
     */
    public function setUnregisteredExtCallsDestination($unregisteredExtCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unregisteredExtCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unregisteredExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unregisteredExtCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unregisteredExtCallsDestination) && !is_string($unregisteredExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unregisteredExtCallsDestination)), __LINE__);
        }
        $this->unregisteredExtCallsDestination = $unregisteredExtCallsDestination;
        return $this;
    }
    /**
     * Get unregisteredExtCallsCss value
     * @return \StructType\XFkType|null
     */
    public function getUnregisteredExtCallsCss()
    {
        return $this->unregisteredExtCallsCss;
    }
    /**
     * Set unregisteredExtCallsCss value
     * @param \StructType\XFkType $unregisteredExtCallsCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setUnregisteredExtCallsCss(\StructType\XFkType $unregisteredExtCallsCss = null)
    {
        $this->unregisteredExtCallsCss = $unregisteredExtCallsCss;
        return $this;
    }
    /**
     * Get ctiFailureDestination value
     * @return string|null
     */
    public function getCtiFailureDestination()
    {
        return $this->ctiFailureDestination;
    }
    /**
     * Set ctiFailureDestination value
     * @param string $ctiFailureDestination
     * @return \StructType\LUniversalLineTemplate
     */
    public function setCtiFailureDestination($ctiFailureDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ctiFailureDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ctiFailureDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ctiFailureDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ctiFailureDestination) && !is_string($ctiFailureDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ctiFailureDestination)), __LINE__);
        }
        $this->ctiFailureDestination = $ctiFailureDestination;
        return $this;
    }
    /**
     * Get ctiFailureCss value
     * @return \StructType\XFkType|null
     */
    public function getCtiFailureCss()
    {
        return $this->ctiFailureCss;
    }
    /**
     * Set ctiFailureCss value
     * @param \StructType\XFkType $ctiFailureCss
     * @return \StructType\LUniversalLineTemplate
     */
    public function setCtiFailureCss(\StructType\XFkType $ctiFailureCss = null)
    {
        $this->ctiFailureCss = $ctiFailureCss;
        return $this;
    }
    /**
     * Get callControlAgentProfile value
     * @return string|null
     */
    public function getCallControlAgentProfile()
    {
        return $this->callControlAgentProfile;
    }
    /**
     * Set callControlAgentProfile value
     * @param string $callControlAgentProfile
     * @return \StructType\LUniversalLineTemplate
     */
    public function setCallControlAgentProfile($callControlAgentProfile = null)
    {
        // validation for constraint: string
        if (!is_null($callControlAgentProfile) && !is_string($callControlAgentProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callControlAgentProfile)), __LINE__);
        }
        $this->callControlAgentProfile = $callControlAgentProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return \StructType\EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param \StructType\EnterpriseAltNum $enterpriseAltNum
     * @return \StructType\LUniversalLineTemplate
     */
    public function setEnterpriseAltNum(\StructType\EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return \StructType\E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param \StructType\E164AltNum $e164AltNum
     * @return \StructType\LUniversalLineTemplate
     */
    public function setE164AltNum(\StructType\E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get advertisedFailoverNumber value
     * @return string|null
     */
    public function getAdvertisedFailoverNumber()
    {
        return $this->advertisedFailoverNumber;
    }
    /**
     * Set advertisedFailoverNumber value
     * @param string $advertisedFailoverNumber
     * @return \StructType\LUniversalLineTemplate
     */
    public function setAdvertisedFailoverNumber($advertisedFailoverNumber = null)
    {
        // validation for constraint: string
        if (!is_null($advertisedFailoverNumber) && !is_string($advertisedFailoverNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertisedFailoverNumber)), __LINE__);
        }
        $this->advertisedFailoverNumber = $advertisedFailoverNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LUniversalLineTemplate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LUniversalLineTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
