<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSubscribedService StructType
 * @subpackage Structs
 */
class LSubscribedService extends AbstractStructBase
{
    /**
     * The telecasterServiceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $telecasterServiceName;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $name;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The urlButtonIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlButtonIndex;
    /**
     * The urlLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $urlLabel;
    /**
     * The serviceNameAscii
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $serviceNameAscii;
    /**
     * The phoneService
     * Meta informations extracted from the WSDL
     * - documentation: Read-only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneService;
    /**
     * The phoneServiceCategory
     * Meta informations extracted from the WSDL
     * - documentation: Read-only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneServiceCategory;
    /**
     * The vendor
     * Meta informations extracted from the WSDL
     * - documentation: Read-only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendor;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: Read-only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - documentation: Read Only. Value should be between 1 and 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $priority;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSubscribedService
     * @uses LSubscribedService::setTelecasterServiceName()
     * @uses LSubscribedService::setName()
     * @uses LSubscribedService::setUrl()
     * @uses LSubscribedService::setUrlButtonIndex()
     * @uses LSubscribedService::setUrlLabel()
     * @uses LSubscribedService::setServiceNameAscii()
     * @uses LSubscribedService::setPhoneService()
     * @uses LSubscribedService::setPhoneServiceCategory()
     * @uses LSubscribedService::setVendor()
     * @uses LSubscribedService::setVersion()
     * @uses LSubscribedService::setPriority()
     * @uses LSubscribedService::setUuid()
     * @param \StructType\XFkType $telecasterServiceName
     * @param string $name
     * @param string $url
     * @param string $urlButtonIndex
     * @param string $urlLabel
     * @param string $serviceNameAscii
     * @param string $phoneService
     * @param string $phoneServiceCategory
     * @param string $vendor
     * @param string $version
     * @param int $priority
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $telecasterServiceName = null, $name = null, $url = null, $urlButtonIndex = null, $urlLabel = null, $serviceNameAscii = null, $phoneService = null, $phoneServiceCategory = null, $vendor = null, $version = null, $priority = null, $uuid = null)
    {
        $this
            ->setTelecasterServiceName($telecasterServiceName)
            ->setName($name)
            ->setUrl($url)
            ->setUrlButtonIndex($urlButtonIndex)
            ->setUrlLabel($urlLabel)
            ->setServiceNameAscii($serviceNameAscii)
            ->setPhoneService($phoneService)
            ->setPhoneServiceCategory($phoneServiceCategory)
            ->setVendor($vendor)
            ->setVersion($version)
            ->setPriority($priority)
            ->setUuid($uuid);
    }
    /**
     * Get telecasterServiceName value
     * @return \StructType\XFkType|null
     */
    public function getTelecasterServiceName()
    {
        return $this->telecasterServiceName;
    }
    /**
     * Set telecasterServiceName value
     * @param \StructType\XFkType $telecasterServiceName
     * @return \StructType\LSubscribedService
     */
    public function setTelecasterServiceName(\StructType\XFkType $telecasterServiceName = null)
    {
        $this->telecasterServiceName = $telecasterServiceName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LSubscribedService
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 100) || (is_array($name) && count($name) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\LSubscribedService
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get urlButtonIndex value
     * @return string|null
     */
    public function getUrlButtonIndex()
    {
        return $this->urlButtonIndex;
    }
    /**
     * Set urlButtonIndex value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urlButtonIndex
     * @return \StructType\LSubscribedService
     */
    public function setUrlButtonIndex($urlButtonIndex = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($urlButtonIndex)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $urlButtonIndex, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->urlButtonIndex = $urlButtonIndex;
        return $this;
    }
    /**
     * Get urlLabel value
     * @return string|null
     */
    public function getUrlLabel()
    {
        return $this->urlLabel;
    }
    /**
     * Set urlLabel value
     * @param string $urlLabel
     * @return \StructType\LSubscribedService
     */
    public function setUrlLabel($urlLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($urlLabel) && strlen($urlLabel) > 50) || (is_array($urlLabel) && count($urlLabel) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($urlLabel) ? strlen($urlLabel) : count($urlLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($urlLabel) && !is_string($urlLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlLabel)), __LINE__);
        }
        $this->urlLabel = $urlLabel;
        return $this;
    }
    /**
     * Get serviceNameAscii value
     * @return string|null
     */
    public function getServiceNameAscii()
    {
        return $this->serviceNameAscii;
    }
    /**
     * Set serviceNameAscii value
     * @param string $serviceNameAscii
     * @return \StructType\LSubscribedService
     */
    public function setServiceNameAscii($serviceNameAscii = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceNameAscii) && strlen($serviceNameAscii) > 50) || (is_array($serviceNameAscii) && count($serviceNameAscii) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($serviceNameAscii) ? strlen($serviceNameAscii) : count($serviceNameAscii)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceNameAscii) && !is_string($serviceNameAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceNameAscii)), __LINE__);
        }
        $this->serviceNameAscii = $serviceNameAscii;
        return $this;
    }
    /**
     * Get phoneService value
     * @return string|null
     */
    public function getPhoneService()
    {
        return $this->phoneService;
    }
    /**
     * Set phoneService value
     * @uses \EnumType\XPhoneService::valueIsValid()
     * @uses \EnumType\XPhoneService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneService
     * @return \StructType\LSubscribedService
     */
    public function setPhoneService($phoneService = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneService::valueIsValid($phoneService)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneService, implode(', ', \EnumType\XPhoneService::getValidValues())), __LINE__);
        }
        $this->phoneService = $phoneService;
        return $this;
    }
    /**
     * Get phoneServiceCategory value
     * @return string|null
     */
    public function getPhoneServiceCategory()
    {
        return $this->phoneServiceCategory;
    }
    /**
     * Set phoneServiceCategory value
     * @uses \EnumType\XPhoneServiceCategory::valueIsValid()
     * @uses \EnumType\XPhoneServiceCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneServiceCategory
     * @return \StructType\LSubscribedService
     */
    public function setPhoneServiceCategory($phoneServiceCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneServiceCategory::valueIsValid($phoneServiceCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneServiceCategory, implode(', ', \EnumType\XPhoneServiceCategory::getValidValues())), __LINE__);
        }
        $this->phoneServiceCategory = $phoneServiceCategory;
        return $this;
    }
    /**
     * Get vendor value
     * @return string|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * Set vendor value
     * @param string $vendor
     * @return \StructType\LSubscribedService
     */
    public function setVendor($vendor = null)
    {
        // validation for constraint: string
        if (!is_null($vendor) && !is_string($vendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendor)), __LINE__);
        }
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\LSubscribedService
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param int $priority
     * @return \StructType\LSubscribedService
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !is_numeric($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priority)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LSubscribedService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LSubscribedService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
